import axios from 'axios';

const API = '/showcases';

class ShowcaseService {
    get(id) {
        return axios.get(`http://localhost:8080/api/showcases/${id}`, {
            headers: {
                'Content-Type': 'application/json'
            },
            withCredentials: true
        });
    }

    getAll() {
        return axios.get('http://localhost:8080/api/showcases', {
            headers: {
                'Content-Type': 'application/json'
            },
            withCredentials: true
        });
    }

    getProjects(id) {
        return axios.get(`http://localhost:8080/api/showcases/${id}/projects`, {
            headers: {
                'Content-Type': 'application/json'
            },
            withCredentials: true
        });
    }

    addProject(showcase, project) {
        return axios.post(`http://localhost:8080/api/showcases/${showcase.id}/add/${project.id}`, {
            headers: {
                'Content-Type': 'application/json'
            },
            withCredentials: true
        });
    }

    save(showcase, file) {
        const formData = new FormData();
        formData.append('showcase', new Blob([JSON.stringify(showcase)], { type: 'application/json' }));
        formData.append('file', file);

        return axios.post('http://localhost:8080/api/showcases', formData, {
            headers: {
                'Content-Type': 'multipart/form-data'
            },
            withCredentials: true
        });
    }

    delete(id) {
        return axios.delete(`http://localhost:8080/api/showcases/${id}`, {
            withCredentials: true
        });
    }
}

export default new ShowcaseService();