/**
 * Allows disposable instances to be used
 */
interface Disposable {
    isDisposed?(): boolean;
}

/*!
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

interface WindowWithKeyborg extends Window {
    __keyborg?: {
        core: KeyborgCore;
        refs: {
            [id: string]: Keyborg;
        };
    };
}
interface KeyborgProps {
    triggerKeys?: number[];
    dismissKeys?: number[];
}
type KeyborgCallback = (isNavigatingWithKeyboard: boolean) => void;
/**
 * Manages a collection of Keyborg instances in a window/document and updates keyborg state
 */
declare class KeyborgCore implements Disposable {
    readonly id: string;
    private _win?;
    private _isMouseOrTouchUsedTimer;
    private _dismissTimer;
    private _triggerKeys?;
    private _dismissKeys?;
    private _isNavigatingWithKeyboard_DO_NOT_USE;
    constructor(win: WindowWithKeyborg, props?: KeyborgProps);
    get isNavigatingWithKeyboard(): boolean;
    set isNavigatingWithKeyboard(val: boolean);
    dispose(): void;
    isDisposed(): boolean;
    /**
     * Updates all keyborg instances with the keyboard navigation state
     */
    update(): void;
    private _onFocusIn;
    private _onMouseDown;
    private _onMouseOrTouch;
    private _onKeyDown;
    /**
     * @returns whether the keyboard event should trigger keyboard navigation mode
     */
    private _shouldTriggerKeyboardNavigation;
    /**
     * @returns whether the keyboard event should dismiss keyboard navigation mode
     */
    private _shouldDismissKeyboardNavigation;
    private _scheduleDismiss;
}
/**
 * Used to determine the keyboard navigation state
 */
declare class Keyborg {
    private _id;
    private _win?;
    private _core?;
    private _cb;
    static create(win: WindowWithKeyborg, props?: KeyborgProps): Keyborg;
    static dispose(instance: Keyborg): void;
    /**
     * Updates all subscribed callbacks with the keyboard navigation state
     */
    static update(instance: Keyborg, isNavigatingWithKeyboard: boolean): void;
    private constructor();
    private dispose;
    /**
     * @returns Whether the user is navigating with keyboard
     */
    isNavigatingWithKeyboard(): boolean;
    /**
     * @param callback - Called when the keyboard navigation state changes
     */
    subscribe(callback: KeyborgCallback): void;
    /**
     * @param callback - Registered with subscribe
     */
    unsubscribe(callback: KeyborgCallback): void;
    /**
     * Manually set the keyboard navigtion state
     */
    setVal(isNavigatingWithKeyboard: boolean): void;
}
declare function createKeyborg(win: Window, props?: KeyborgProps): Keyborg;
declare function disposeKeyborg(instance: Keyborg): void;

declare const KEYBORG_FOCUSIN = "keyborg:focusin";
declare const KEYBORG_FOCUSOUT = "keyborg:focusout";
interface KeyborgFocusInEventDetails {
    relatedTarget?: HTMLElement;
    isFocusedProgrammatically?: boolean;
    originalEvent?: FocusEvent;
}
interface KeyborgFocusInEvent extends CustomEvent<KeyborgFocusInEventDetails> {
    /**
     * @deprecated - used `event.detail`
     */
    details?: KeyborgFocusInEventDetails;
}
interface KeyborgFocusOutEventDetails {
    originalEvent: FocusEvent;
}
type KeyborgFocusOutEvent = CustomEvent<KeyborgFocusOutEventDetails>;
/**
 * Guarantees that the native `focus` will be used
 */
declare function nativeFocus(element: HTMLElement): void;
/**
 * @param win The window that stores keyborg focus events
 * @returns The last element focused with element.focus()
 */
declare function getLastFocusedProgrammatically(win: Window): HTMLElement | null | undefined;

/*!
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

declare const version: string | undefined;

export { KEYBORG_FOCUSIN, KEYBORG_FOCUSOUT, Keyborg, type KeyborgCallback, type KeyborgFocusInEvent, type KeyborgFocusInEventDetails, type KeyborgFocusOutEvent, type KeyborgFocusOutEventDetails, createKeyborg, disposeKeyborg, getLastFocusedProgrammatically, nativeFocus, version };
