"use client";
import { canUseDOM } from './utils/canUseDOM.esm.js';
import { useInsertionEffect } from './useInsertionEffect.esm.js';

const insertionFactory = () => {
  const insertionCache = {};
  return function insert(renderer, cssRules) {
    // Even if `useInsertionEffect` is available, we can use it on a client only as it will not be executed in SSR
    if (useInsertionEffect && canUseDOM()) {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      useInsertionEffect(() => {
        renderer.insertCSSRules(cssRules);
      }, [renderer, cssRules]);
      return;
    }
    if (insertionCache[renderer.id] === undefined) {
      renderer.insertCSSRules(cssRules);
      insertionCache[renderer.id] = true;
    }
  };
};

export { insertionFactory };
//# sourceMappingURL=insertionFactory.esm.js.map
