"use client";
'use strict';

var canUseDOM = require('./utils/canUseDOM.cjs.js');
var useInsertionEffect = require('./useInsertionEffect.cjs.js');

const insertionFactory = () => {
  const insertionCache = {};
  return function insert(renderer, cssRules) {
    // Even if `useInsertionEffect` is available, we can use it on a client only as it will not be executed in SSR
    if (useInsertionEffect.useInsertionEffect && canUseDOM.canUseDOM()) {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      useInsertionEffect.useInsertionEffect(() => {
        renderer.insertCSSRules(cssRules);
      }, [renderer, cssRules]);
      return;
    }
    if (insertionCache[renderer.id] === undefined) {
      renderer.insertCSSRules(cssRules);
      insertionCache[renderer.id] = true;
    }
  };
};

exports.insertionFactory = insertionFactory;
//# sourceMappingURL=insertionFactory.cjs.js.map
