"use client";
'use strict';

var core = require('@griffel/core');
var TextDirectionContext = require('./TextDirectionContext.cjs.js');

/**
 * A version of makeResetStyles() that accepts build output as an input and skips all runtime transforms & DOM insertion.
 *
 * @internal
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
function __resetCSS(ltrClassName, rtlClassName) {
  const getStyles = core.__resetCSS(ltrClassName, rtlClassName);
  return function useClasses() {
    const dir = TextDirectionContext.useTextDirection();
    return getStyles({
      dir
    });
  };
}

exports.__resetCSS = __resetCSS;
//# sourceMappingURL=__resetCSS.cjs.js.map
