"use client";
import { rehydrateRendererCache, createDOMRenderer } from '@griffel/core';
import * as React from 'react';
import { canUseDOM } from './utils/canUseDOM.esm.js';

/**
 * @private
 */
const RendererContext = /*#__PURE__*/React.createContext(/*#__PURE__*/createDOMRenderer());
/**
 * @public
 */
const RendererProvider = ({
  children,
  renderer,
  targetDocument
}) => {
  React.useMemo(() => {
    if (canUseDOM()) {
      // "rehydrateCache()" can't be called in effects as it needs to be called before any component will be rendered to
      // avoid double insertion of classes
      rehydrateRendererCache(renderer, targetDocument);
    }
  }, [renderer, targetDocument]);
  return /*#__PURE__*/React.createElement(RendererContext.Provider, {
    value: renderer
  }, children);
};
/**
 * Returns an instance of current makeStyles() renderer.
 *
 * @private Exported as "useRenderer_unstable" use it on own risk. Can be changed or removed without a notice.
 */
function useRenderer() {
  return React.useContext(RendererContext);
}

export { RendererProvider, useRenderer };
//# sourceMappingURL=RendererContext.esm.js.map
