"use client";
'use strict';

var core = require('@griffel/core');
var React = require('react');
var canUseDOM = require('./utils/canUseDOM.cjs.js');

function _interopNamespaceCompat(e) {
  if (e && typeof e === 'object' && 'default' in e) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceCompat(React);

/**
 * @private
 */
const RendererContext = /*#__PURE__*/React__namespace.createContext(/*#__PURE__*/core.createDOMRenderer());
/**
 * @public
 */
const RendererProvider = ({
  children,
  renderer,
  targetDocument
}) => {
  React__namespace.useMemo(() => {
    if (canUseDOM.canUseDOM()) {
      // "rehydrateCache()" can't be called in effects as it needs to be called before any component will be rendered to
      // avoid double insertion of classes
      core.rehydrateRendererCache(renderer, targetDocument);
    }
  }, [renderer, targetDocument]);
  return /*#__PURE__*/React__namespace.createElement(RendererContext.Provider, {
    value: renderer
  }, children);
};
/**
 * Returns an instance of current makeStyles() renderer.
 *
 * @private Exported as "useRenderer_unstable" use it on own risk. Can be changed or removed without a notice.
 */
function useRenderer() {
  return React__namespace.useContext(RendererContext);
}

exports.RendererProvider = RendererProvider;
exports.useRenderer = useRenderer;
//# sourceMappingURL=RendererContext.cjs.js.map
