export declare const mergeClassesCachedResults: Record<string, string>;
/**
 * Function can take any number of arguments, joins classes together and deduplicates atomic declarations generated by
 * `makeStyles()`. Handles scoped directional styles.
 *
 * Classnames can be of any length, this function can take both atomic declarations and class names.
 *
 * Input:
 * ```
 * // not real classes
 * mergeClasses('ui-button', 'displayflex', 'displaygrid')
 * ```
 *
 * Output:
 * ```
 * 'ui-button displaygrid'
 * ```
 */
export declare function mergeClasses(...classNames: (string | false | undefined)[]): string;
