import { border, borderLeft, borderBottom, borderRight, borderTop, borderColor, borderStyle, borderRadius, borderWidth, flex, gap, gridArea, margin, marginBlock, marginInline, padding, paddingBlock, paddingInline, overflow, inset, outline, transition, textDecoration } from './shorthands';
export declare const shorthands: {
    border: typeof border;
    borderLeft: typeof borderLeft;
    borderBottom: typeof borderBottom;
    borderRight: typeof borderRight;
    borderTop: typeof borderTop;
    borderColor: typeof borderColor;
    borderStyle: typeof borderStyle;
    borderRadius: typeof borderRadius;
    borderWidth: typeof borderWidth;
    flex: typeof flex;
    gap: typeof gap;
    gridArea: typeof gridArea;
    margin: typeof margin;
    marginBlock: typeof marginBlock;
    marginInline: typeof marginInline;
    padding: typeof padding;
    paddingBlock: typeof paddingBlock;
    paddingInline: typeof paddingInline;
    overflow: typeof overflow;
    inset: typeof inset;
    outline: typeof outline;
    transition: typeof transition;
    textDecoration: typeof textDecoration;
};
export { createDOMRenderer } from './renderer/createDOMRenderer';
export type { CreateDOMRendererOptions } from './renderer/createDOMRenderer';
export { rehydrateRendererCache } from './renderer/rehydrateRendererCache';
export { safeInsertRule } from './renderer/safeInsertRule';
export { mergeClasses } from './mergeClasses';
export { makeStyles } from './makeStyles';
export type { MakeStylesOptions } from './makeStyles';
export { makeStaticStyles } from './makeStaticStyles';
export type { MakeStaticStylesOptions } from './makeStaticStyles';
export { makeResetStyles } from './makeResetStyles';
export { resolveStyleRulesForSlots } from './resolveStyleRulesForSlots';
export { __css } from './__css';
export { __styles } from './__styles';
export { __resetCSS } from './__resetCSS';
export { __resetStyles } from './__resetStyles';
export { normalizeCSSBucketEntry } from './runtime/utils/normalizeCSSBucketEntry';
export { styleBucketOrdering, getStyleSheetKey } from './renderer/getStyleSheetForBucket';
export { defaultCompareMediaQueries } from './renderer/createDOMRenderer';
export { getStyleBucketName } from './runtime/getStyleBucketName';
export { reduceToClassNameForSlots } from './runtime/reduceToClassNameForSlots';
export { resolveStyleRules } from './runtime/resolveStyleRules';
export { resolveResetStyleRules } from './runtime/resolveResetStyleRules';
export * from './constants';
export type { GriffelStaticStyle, GriffelStaticStyles, GriffelAnimation, GriffelStyle, GriffelResetStyle, } from '@griffel/style-types';
export type { CSSClasses, CSSClassesMapBySlot, CSSBucketEntry, CSSRulesByBucket, StyleBucketName, GriffelRenderer, GriffelInsertionFactory, } from './types';
export type { DebugCSSRules, DebugSequence, DebugResult } from './devtools';
