import { isBorderStyle } from './utils.esm.js';

/**
 * A function that implements expansion for "border-Bottom", it's simplified - check usage examples.
 *
 * @example
 *  borderBottom('2px')
 *  borderBottom('solid')
 *  borderBottom('2px', 'solid')
 *  borderBottom('solid', '2px')
 *  borderBottom('2px', 'solid', 'red')
 *  borderBottom('solid', '2px', 'red')
 *
 * See https://developer.mozilla.org/en-US/docs/Web/CSS/border-bottom
 *
 * @deprecated Just use `{ borderBottom: '2px solid red' }` instead as Griffel supports CSS shorthands now
 */
function borderBottom(...values) {
  if (isBorderStyle(values[0])) {
    return Object.assign({
      borderBottomStyle: values[0]
    }, values[1] && {
      borderBottomWidth: values[1]
    }, values[2] && {
      borderBottomColor: values[2]
    });
  }
  return Object.assign({
    borderBottomWidth: values[0]
  }, values[1] && {
    borderBottomStyle: values[1]
  }, values[2] && {
    borderBottomColor: values[2]
  });
}

export { borderBottom };
//# sourceMappingURL=borderBottom.esm.js.map
