'use strict';

var borderWidth = require('./borderWidth.cjs.js');
var borderStyle = require('./borderStyle.cjs.js');
var borderColor = require('./borderColor.cjs.js');
var utils = require('./utils.cjs.js');

/**
 * A function that implements expansion for "border" to all sides of an element, it's simplified - check usage examples.
 *
 * @example
 *  border('2px')
 *  border('solid')
 *  border('2px', 'solid')
 *  border('solid', '2px')
 *  border('2px', 'solid', 'red')
 *  border('solid', '2px', 'red')
 *
 * See https://developer.mozilla.org/en-US/docs/Web/CSS/border
 *
 * @deprecated Just use `{ border: '2px solid red' }` instead as Griffel supports CSS shorthands now
 */
function border(...values) {
  if (utils.isBorderStyle(values[0])) {
    return Object.assign({}, borderStyle.borderStyle(values[0]), values[1] && borderWidth.borderWidth(values[1]), values[2] && borderColor.borderColor(values[2]));
  }
  return Object.assign({}, borderWidth.borderWidth(values[0]), values[1] && borderStyle.borderStyle(values[1]), values[2] && borderColor.borderColor(values[2]));
}

exports.border = border;
//# sourceMappingURL=border.cjs.js.map
