'use strict';

var stylis = require('stylis');

/* eslint-disable no-fallthrough */
function prefix(value, length, children) {
  switch (stylis.hash(value, length)) {
    // color-adjust
    case 5103:
      return stylis.WEBKIT + 'print-' + value + value;
    // backface-visibility, column, box-decoration-break
    case 3191:
    case 6645:
    case 3005:
    // mask, mask-image, mask-(mode|clip|size), mask-(repeat|origin), mask-position, mask-composite
    case 6391:
    case 5879:
    case 5623:
    case 6135:
    case 4599:
    case 4855:
      return stylis.WEBKIT + value + value;
    // backdrop-filter, background-clip: text
    case 4215:
      // Additional check on "backdrop-(f)ilter" to prevent conflict with "background-clip"
      // https://github.com/thysultan/stylis/issues/292
      if (stylis.charat(value, 9) === 102) {
        return stylis.WEBKIT + value + value;
      }
      // background-clip: text
      if (stylis.charat(value, length + 1) === 116) {
        return stylis.WEBKIT + value + value;
      }
      break;
    // tab-size
    case 4789:
      return stylis.MOZ + value + value;
    // appearance, user-select, hyphens
    case 5349:
    case 4246:
    case 6968:
      return stylis.WEBKIT + value + stylis.MOZ + value + value;
    // cursor
    // @ts-expect-error fall through is intentional here
    case 6187:
      if (!stylis.match(value, /grab/)) {
        return stylis.replace(stylis.replace(stylis.replace(value, /(zoom-|grab)/, stylis.WEBKIT + '$1'), /(image-set)/, stylis.WEBKIT + '$1'), value, '') + value;
      }
    // background, background-image
    case 5495:
    case 3959:
      // eslint-disable-next-line no-useless-concat
      return stylis.replace(value, /(image-set\([^]*)/, stylis.WEBKIT + '$1' + '$`$1');
    // (margin|padding)-inline-(start|end)
    case 4095:
    case 3583:
    case 4068:
    case 2532:
      return stylis.replace(value, /(.+)-inline(.+)/, stylis.WEBKIT + '$1$2') + value;
    // (min|max)?(width|height|inline-size|block-size)
    case 8116:
    case 7059:
    case 5753:
    case 5535:
    case 5445:
    case 5701:
    case 4933:
    case 4677:
    case 5533:
    case 5789:
    case 5021:
    case 4765:
      // stretch fill-available
      if (stylis.strlen(value) - 1 - length > 6) switch (stylis.charat(value, length + 1)) {
        // (f)ill-available
        // @ts-expect-error fall through is intentional here
        case 102:
          if (stylis.charat(value, length + 3) === 108) {
            return stylis.replace(value, /(.+:)(.+)-([^]+)/,
            // eslint-disable-next-line no-useless-concat, eqeqeq
            '$1' + stylis.WEBKIT + '$2-$3' + '$1' + stylis.MOZ + (stylis.charat(value, length + 3) == 108 ? '$3' : '$2-$3')) + value;
          }
        // (s)tretch
        case 115:
          return ~stylis.indexof(value, 'stretch') ? prefix(stylis.replace(value, 'stretch', 'fill-available'), length) + value : value;
      }
      break;
  }
  return value;
}
/**
 * @param {object} element
 * @param {number} index
 * @param {object[]} children
 * @param {function} callback
 */
function prefixerPlugin(element, index, children, callback) {
  if (element.length > -1) if (!element.return) switch (element.type) {
    case stylis.DECLARATION:
      element.return = prefix(element.value, element.length);
      return;
    case stylis.RULESET:
      if (element.length)
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        return stylis.combine(element.props, function (value) {
          switch (stylis.match(value, /(::plac\w+|:read-\w+)/)) {
            // :read-(only|write)
            case ':read-only':
            case ':read-write':
              return stylis.serialize(
              // eslint-disable-next-line @typescript-eslint/ban-ts-comment
              // @ts-ignore
              [stylis.copy(element, {
                props: [stylis.replace(value, /:(read-\w+)/, ':' + stylis.MOZ + '$1')]
              })], callback);
            // :placeholder
            case '::placeholder':
              return stylis.serialize([
              // eslint-disable-next-line @typescript-eslint/ban-ts-comment
              // @ts-ignore
              stylis.copy(element, {
                props: [stylis.replace(value, /:(plac\w+)/, ':' + stylis.WEBKIT + 'input-$1')]
              }),
              // eslint-disable-next-line @typescript-eslint/ban-ts-comment
              // @ts-ignore
              stylis.copy(element, {
                props: [stylis.replace(value, /:(plac\w+)/, ':' + stylis.MOZ + '$1')]
              })], callback);
          }
          return '';
        });
  }
  return undefined;
}

exports.prefix = prefix;
exports.prefixerPlugin = prefixerPlugin;
//# sourceMappingURL=prefixerPlugin.cjs.js.map
