'use strict';

var compileCSSRules = require('./compileCSSRules.cjs.js');
var compileStaticCSS = require('./compileStaticCSS.cjs.js');

function resolveStaticStyleRules(stylesSet) {
  return stylesSet.reduce((acc, styles) => {
    if (typeof styles === 'string') {
      const cssRules = compileCSSRules.compileCSSRules(styles, false);
      for (const rule of cssRules) {
        acc.push(rule);
      }
      return acc;
    }
    // eslint-disable-next-line guard-for-in
    for (const property in styles) {
      const value = styles[property];
      const staticCSS = compileStaticCSS.compileStaticCSS(property, value);
      acc.push(staticCSS);
    }
    return acc;
  }, []);
}

exports.resolveStaticStyleRules = resolveStaticStyleRules;
//# sourceMappingURL=resolveStaticStyleRules.cjs.js.map
