'use strict';

var hashString = require('@emotion/hash');
var core = require('rtl-css-js/core');
var constants = require('../constants.cjs.js');
var isMediaQuerySelector = require('./utils/isMediaQuerySelector.cjs.js');
var isLayerSelector = require('./utils/isLayerSelector.cjs.js');
var isNestedSelector = require('./utils/isNestedSelector.cjs.js');
var isSupportQuerySelector = require('./utils/isSupportQuerySelector.cjs.js');
var isObject = require('./utils/isObject.cjs.js');
var hyphenateProperty = require('./utils/hyphenateProperty.cjs.js');
var compileAtomicCSSRule = require('./compileAtomicCSSRule.cjs.js');
var compileResetCSSRules = require('./compileResetCSSRules.cjs.js');
var compileKeyframeCSS = require('./compileKeyframeCSS.cjs.js');
var isContainerQuerySelector = require('./utils/isContainerQuerySelector.cjs.js');
var warnAboutUnresolvedRule = require('./warnings/warnAboutUnresolvedRule.cjs.js');

function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e : { default: e }; }

var hashString__default = /*#__PURE__*/_interopDefaultCompat(hashString);

/**
 * @internal
 */
function createStringFromStyles(styles) {
  let ltrCSS = '';
  let rtlCSS = '';
  // eslint-disable-next-line guard-for-in
  for (const property in styles) {
    const value = styles[property];
    // eslint-disable-next-line eqeqeq
    if (value == null) {
      continue;
    }
    if (typeof value === 'string' || typeof value === 'number') {
      const {
        key: rtlProperty,
        value: rtlValue
      } = core.convertProperty(property, value);
      ltrCSS += `${hyphenateProperty.hyphenateProperty(property)}:${value};`;
      rtlCSS += `${hyphenateProperty.hyphenateProperty(rtlProperty)}:${rtlValue};`;
      continue;
    }
    if (property === 'animationName' && typeof value === 'object') {
      const values = Array.isArray(value) ? value : [value];
      const ltrAnimationNames = [];
      const rtlAnimationNames = [];
      for (const keyframeObject of values) {
        const ltrKeyframeRule = compileKeyframeCSS.compileKeyframeRule(keyframeObject);
        const rtlKeyframeRule = compileKeyframeCSS.compileKeyframeRule(core.convert(keyframeObject));
        const ltrAnimationName = constants.RESET_HASH_PREFIX + hashString__default.default(ltrKeyframeRule);
        const rtlAnimationName = constants.RESET_HASH_PREFIX + hashString__default.default(rtlKeyframeRule);
        ltrAnimationNames.push(ltrAnimationName);
        rtlAnimationNames.push(rtlAnimationName);
        ltrCSS += compileKeyframeCSS.compileKeyframesCSS(ltrAnimationName, ltrKeyframeRule).join('');
        if (ltrAnimationName !== rtlAnimationName) {
          rtlCSS += compileKeyframeCSS.compileKeyframesCSS(rtlAnimationName, rtlKeyframeRule).join('');
        }
      }
      ltrCSS += `animation-name:${ltrAnimationNames.join(',')};`;
      rtlCSS += `animation-name:${rtlAnimationNames.join(',')};`;
      continue;
    }
    if (Array.isArray(value)) {
      // not animationName property but array in the value => fallback values
      if (value.length === 0) {
        if (process.env.NODE_ENV !== 'production') {
          console.warn(`makeResetStyles(): An empty array was passed as input to "${property}", the property will be omitted in the styles.`);
        }
        continue;
      }
      const rtlDefinitions = value.map(v => core.convertProperty(property, v));
      const rtlPropertyConsistent = !rtlDefinitions.some(v => v.key !== rtlDefinitions[0].key);
      if (!rtlPropertyConsistent) {
        if (process.env.NODE_ENV !== 'production') {
          console.error('makeStyles(): mixing CSS fallback values which result in multiple CSS properties in RTL is not supported.');
        }
        continue;
      }
      const rtlProperty = rtlDefinitions[0].key;
      ltrCSS += value.map(v => `${hyphenateProperty.hyphenateProperty(property)}:${v};`).join('');
      rtlCSS += rtlDefinitions.map(definition => `${hyphenateProperty.hyphenateProperty(rtlProperty)}:${definition.value};`).join('');
      continue;
    }
    if (isObject.isObject(value)) {
      if (isNestedSelector.isNestedSelector(property)) {
        const nestedSelector = compileAtomicCSSRule.normalizePseudoSelector(property);
        const [ltrNested, rtlNested] = createStringFromStyles(value);
        ltrCSS += `${nestedSelector}{${ltrNested}}`;
        rtlCSS += `${nestedSelector}{${rtlNested}}`;
        continue;
      }
      if (isMediaQuerySelector.isMediaQuerySelector(property) || isLayerSelector.isLayerSelector(property) || isSupportQuerySelector.isSupportQuerySelector(property) || isContainerQuerySelector.isContainerQuerySelector(property)) {
        const [ltrNested, rtlNested] = createStringFromStyles(value);
        ltrCSS += `${property}{${ltrNested}}`;
        rtlCSS += `${property}{${rtlNested}}`;
        continue;
      }
    }
    warnAboutUnresolvedRule.warnAboutUnresolvedRule(property, value);
  }
  return [ltrCSS, rtlCSS];
}
/**
 * @internal
 */
function resolveResetStyleRules(styles, classNameHashSalt = '') {
  const [ltrRule, rtlRule] = createStringFromStyles(styles);
  const ltrClassName = constants.RESET_HASH_PREFIX + hashString__default.default(classNameHashSalt + ltrRule);
  const [ltrCSS, ltrCSSAtRules] = compileResetCSSRules.compileResetCSSRules(`.${ltrClassName}{${ltrRule}}`);
  const hasAtRules = ltrCSSAtRules.length > 0;
  if (ltrRule === rtlRule) {
    return [ltrClassName, null, hasAtRules ? {
      r: ltrCSS,
      s: ltrCSSAtRules
    } : ltrCSS];
  }
  const rtlClassName = constants.RESET_HASH_PREFIX + hashString__default.default(classNameHashSalt + rtlRule);
  const [rtlCSS, rtlCSSAtRules] = compileResetCSSRules.compileResetCSSRules(`.${rtlClassName}{${rtlRule}}`);
  return [ltrClassName, rtlClassName, hasAtRules ? {
    r: ltrCSS.concat(rtlCSS),
    s: ltrCSSAtRules.concat(rtlCSSAtRules)
  } : ltrCSS.concat(rtlCSS)];
}

exports.resolveResetStyleRules = resolveResetStyleRules;
//# sourceMappingURL=resolveResetStyleRules.cjs.js.map
