'use strict';

var stylis = require('stylis');
var globalPlugin = require('./stylis/globalPlugin.cjs.js');
var isAtRuleElement = require('./stylis/isAtRuleElement.cjs.js');
var prefixerPlugin = require('./stylis/prefixerPlugin.cjs.js');
var rulesheetPlugin = require('./stylis/rulesheetPlugin.cjs.js');

function compileResetCSSRules(cssRules) {
  const rules = [];
  const atRules = [];
  stylis.serialize(stylis.compile(cssRules), stylis.middleware([globalPlugin.globalPlugin, prefixerPlugin.prefixerPlugin, stylis.stringify,
  // 💡 we are using `.insertRule()` API for DOM operations, which does not support
  // insertion of multiple CSS rules in a single call. `rulesheet` plugin extracts
  // individual rules to be used with this API
  rulesheetPlugin.rulesheetPlugin((element, rule) => {
    if (isAtRuleElement.isAtRuleElement(element)) {
      atRules.push(rule);
      return;
    }
    rules.push(rule);
  })]));
  return [rules, atRules];
}

exports.compileResetCSSRules = compileResetCSSRules;
//# sourceMappingURL=compileResetCSSRules.cjs.js.map
