'use strict';

var stylis = require('stylis');
var globalPlugin = require('./stylis/globalPlugin.cjs.js');
var prefixerPlugin = require('./stylis/prefixerPlugin.cjs.js');
var sortClassesInAtRulesPlugin = require('./stylis/sortClassesInAtRulesPlugin.cjs.js');

// eslint-disable-next-line @typescript-eslint/no-empty-function
function noop() {}
function compileCSSRules(cssRules, sortClassesInAtRules) {
  const rules = [];
  stylis.serialize(stylis.compile(cssRules), stylis.middleware([globalPlugin.globalPlugin, sortClassesInAtRules ? sortClassesInAtRulesPlugin.sortClassesInAtRulesPlugin : noop, prefixerPlugin.prefixerPlugin, stylis.stringify,
  // 💡 we are using `.insertRule()` API for DOM operations, which does not support
  // insertion of multiple CSS rules in a single call. `rulesheet` plugin extracts
  // individual rules to be used with this API
  stylis.rulesheet(rule => rules.push(rule))]));
  return rules;
}

exports.compileCSSRules = compileCSSRules;
//# sourceMappingURL=compileCSSRules.cjs.js.map
