'use strict';

var injectDevTools = require('../devtools/injectDevTools.cjs.js');
var isDevToolsEnabled = require('../devtools/isDevToolsEnabled.cjs.js');
var store = require('../devtools/store.cjs.js');
var normalizeCSSBucketEntry = require('../runtime/utils/normalizeCSSBucketEntry.cjs.js');
var getStyleSheetForBucket = require('./getStyleSheetForBucket.cjs.js');
var safeInsertRule = require('./safeInsertRule.cjs.js');

let lastIndex = 0;
/** @internal */
const defaultCompareMediaQueries = (a, b) => a < b ? -1 : a > b ? 1 : 0;
/**
 * Creates a new instances of a renderer.
 *
 * @public
 */
function createDOMRenderer(targetDocument = typeof document === 'undefined' ? undefined : document, options = {}) {
  const {
    classNameHashSalt,
    unstable_filterCSSRule,
    insertionPoint,
    styleElementAttributes,
    compareMediaQueries = defaultCompareMediaQueries
  } = options;
  const renderer = {
    classNameHashSalt,
    insertionCache: {},
    stylesheets: {},
    styleElementAttributes: Object.freeze(styleElementAttributes),
    compareMediaQueries,
    id: `d${lastIndex++}`,
    insertCSSRules(cssRules) {
      // eslint-disable-next-line guard-for-in
      for (const styleBucketName in cssRules) {
        const cssRulesForBucket = cssRules[styleBucketName];
        // This is a hot path in rendering styles: ".length" is cached in "l" var to avoid accesses the property
        for (let i = 0, l = cssRulesForBucket.length; i < l; i++) {
          const [ruleCSS, metadata] = normalizeCSSBucketEntry.normalizeCSSBucketEntry(cssRulesForBucket[i]);
          const sheet = getStyleSheetForBucket.getStyleSheetForBucket(styleBucketName, targetDocument, insertionPoint || null, renderer, metadata);
          if (renderer.insertionCache[ruleCSS]) {
            continue;
          }
          renderer.insertionCache[ruleCSS] = styleBucketName;
          if (process.env.NODE_ENV !== 'production' && isDevToolsEnabled.isDevToolsEnabled) {
            store.debugData.addCSSRule(ruleCSS);
          }
          if (unstable_filterCSSRule) {
            if (unstable_filterCSSRule(ruleCSS)) {
              safeInsertRule.safeInsertRule(sheet, ruleCSS);
            }
          } else {
            safeInsertRule.safeInsertRule(sheet, ruleCSS);
          }
        }
      }
    }
  };
  if (targetDocument && process.env.NODE_ENV !== 'production' && isDevToolsEnabled.isDevToolsEnabled) {
    injectDevTools.injectDevTools(targetDocument);
  }
  return renderer;
}

exports.createDOMRenderer = createDOMRenderer;
exports.defaultCompareMediaQueries = defaultCompareMediaQueries;
//# sourceMappingURL=createDOMRenderer.cjs.js.map
