'use strict';

var insertionFactory = require('./insertionFactory.cjs.js');
var resolveStaticStyleRules = require('./runtime/resolveStaticStyleRules.cjs.js');

function makeStaticStyles(styles, factory = insertionFactory.insertionFactory) {
  const insertStyles = factory();
  const stylesSet = Array.isArray(styles) ? styles : [styles];
  function useStaticStyles(options) {
    insertStyles(options.renderer,
    // 👇 static rules should be inserted into default bucket
    {
      d: resolveStaticStyleRules.resolveStaticStyleRules(stylesSet)
    });
  }
  return useStaticStyles;
}

exports.makeStaticStyles = makeStaticStyles;
//# sourceMappingURL=makeStaticStyles.cjs.js.map
