'use strict';

require('./constants.cjs.js');
var store = require('./devtools/store.cjs.js');
var isDevToolsEnabled = require('./devtools/isDevToolsEnabled.cjs.js');
var getSourceURLfromError = require('./devtools/getSourceURLfromError.cjs.js');
var insertionFactory = require('./insertionFactory.cjs.js');
var reduceToClassNameForSlots = require('./runtime/reduceToClassNameForSlots.cjs.js');

/**
 * A version of makeStyles() that accepts build output as an input and skips all runtime transforms.
 *
 * @internal
 */
function __styles(classesMapBySlot, cssRules, factory = insertionFactory.insertionFactory) {
  const insertStyles = factory();
  let ltrClassNamesForSlots = null;
  let rtlClassNamesForSlots = null;
  let sourceURL;
  if (process.env.NODE_ENV !== 'production' && isDevToolsEnabled.isDevToolsEnabled) {
    sourceURL = getSourceURLfromError.getSourceURLfromError();
  }
  function computeClasses(options) {
    const {
      dir,
      renderer
    } = options;
    const isLTR = dir === 'ltr';
    if (isLTR) {
      if (ltrClassNamesForSlots === null) {
        ltrClassNamesForSlots = reduceToClassNameForSlots.reduceToClassNameForSlots(classesMapBySlot, dir);
      }
    } else {
      if (rtlClassNamesForSlots === null) {
        rtlClassNamesForSlots = reduceToClassNameForSlots.reduceToClassNameForSlots(classesMapBySlot, dir);
      }
    }
    insertStyles(renderer, cssRules);
    const classNamesForSlots = isLTR ? ltrClassNamesForSlots : rtlClassNamesForSlots;
    if (process.env.NODE_ENV !== 'production' && isDevToolsEnabled.isDevToolsEnabled) {
      store.debugData.addSequenceDetails(classNamesForSlots, sourceURL);
    }
    return classNamesForSlots;
  }
  return computeClasses;
}

exports.__styles = __styles;
//# sourceMappingURL=__styles.cjs.js.map
