'use strict';

var constants = require('./constants.cjs.js');
var insertionFactory = require('./insertionFactory.cjs.js');

/**
 * @internal
 */
function __resetStyles(ltrClassName, rtlClassName, cssRules, factory = insertionFactory.insertionFactory) {
  const insertStyles = factory();
  function computeClassName(options) {
    const {
      dir,
      renderer
    } = options;
    const className = dir === 'ltr' ? ltrClassName : rtlClassName || ltrClassName;
    insertStyles(renderer, Array.isArray(cssRules) ? {
      r: cssRules
    } : cssRules);
    if (process.env.NODE_ENV !== 'production') {
      constants.DEBUG_RESET_CLASSES[className] = 1;
    }
    return className;
  }
  return computeClassName;
}

exports.__resetStyles = __resetStyles;
//# sourceMappingURL=__resetStyles.cjs.js.map
