import { DEBUG_RESET_CLASSES } from './constants.esm.js';

/**
 * @internal
 */
function __resetCSS(ltrClassName, rtlClassName) {
  function computeClassName(options) {
    const {
      dir
    } = options;
    const className = dir === 'ltr' ? ltrClassName : rtlClassName || ltrClassName;
    if (process.env.NODE_ENV !== 'production') {
      DEBUG_RESET_CLASSES[className] = 1;
    }
    return className;
  }
  return computeClassName;
}

export { __resetCSS };
//# sourceMappingURL=__resetCSS.esm.js.map
