'use strict';

var constants = require('./constants.cjs.js');

/**
 * @internal
 */
function __resetCSS(ltrClassName, rtlClassName) {
  function computeClassName(options) {
    const {
      dir
    } = options;
    const className = dir === 'ltr' ? ltrClassName : rtlClassName || ltrClassName;
    if (process.env.NODE_ENV !== 'production') {
      constants.DEBUG_RESET_CLASSES[className] = 1;
    }
    return className;
  }
  return computeClassName;
}

exports.__resetCSS = __resetCSS;
//# sourceMappingURL=__resetCSS.cjs.js.map
