"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    colorPaletteTokens: function() {
        return colorPaletteTokens;
    },
    colorStatusTokens: function() {
        return colorStatusTokens;
    }
});
const _colorPalette = require("../global/colorPalette.js");
const _sharedColorNames = require("../sharedColorNames.js");
const _statusColorMapping = require("../statusColorMapping.js");
const statusColorPaletteTokens = _sharedColorNames.statusSharedColorNames.reduce((acc, sharedColor)=>{
    const color = sharedColor.slice(0, 1).toUpperCase() + sharedColor.slice(1);
    const sharedColorTokens = {
        [`colorPalette${color}Background1`]: _colorPalette.statusSharedColors[sharedColor].tint60,
        [`colorPalette${color}Background2`]: _colorPalette.statusSharedColors[sharedColor].tint40,
        [`colorPalette${color}Background3`]: _colorPalette.statusSharedColors[sharedColor].primary,
        [`colorPalette${color}Foreground1`]: _colorPalette.statusSharedColors[sharedColor].shade10,
        [`colorPalette${color}Foreground2`]: _colorPalette.statusSharedColors[sharedColor].shade30,
        [`colorPalette${color}Foreground3`]: _colorPalette.statusSharedColors[sharedColor].primary,
        [`colorPalette${color}BorderActive`]: _colorPalette.statusSharedColors[sharedColor].primary,
        [`colorPalette${color}Border1`]: _colorPalette.statusSharedColors[sharedColor].tint40,
        [`colorPalette${color}Border2`]: _colorPalette.statusSharedColors[sharedColor].primary
    };
    return Object.assign(acc, sharedColorTokens);
}, {});
// one-off patch for yellow
statusColorPaletteTokens.colorPaletteYellowForeground1 = _colorPalette.statusSharedColors.yellow.shade30;
statusColorPaletteTokens.colorPaletteRedForegroundInverted = _colorPalette.statusSharedColors.red.tint20;
statusColorPaletteTokens.colorPaletteGreenForegroundInverted = _colorPalette.statusSharedColors.green.tint20;
statusColorPaletteTokens.colorPaletteYellowForegroundInverted = _colorPalette.statusSharedColors.yellow.tint40;
const personaColorPaletteTokens = _sharedColorNames.personaSharedColorNames.reduce((acc, sharedColor)=>{
    const color = sharedColor.slice(0, 1).toUpperCase() + sharedColor.slice(1);
    const sharedColorTokens = {
        [`colorPalette${color}Background2`]: _colorPalette.personaSharedColors[sharedColor].tint40,
        [`colorPalette${color}Foreground2`]: _colorPalette.personaSharedColors[sharedColor].shade30,
        [`colorPalette${color}BorderActive`]: _colorPalette.personaSharedColors[sharedColor].primary
    };
    return Object.assign(acc, sharedColorTokens);
}, {});
const colorPaletteTokens = {
    ...statusColorPaletteTokens,
    ...personaColorPaletteTokens
};
const colorStatusTokens = Object.entries(_statusColorMapping.statusColorMapping).reduce((acc, [statusColor, sharedColor])=>{
    const color = statusColor.slice(0, 1).toUpperCase() + statusColor.slice(1);
    // TODO: double check the mapping with design
    const statusColorTokens = {
        [`colorStatus${color}Background1`]: _colorPalette.mappedStatusColors[sharedColor].tint60,
        [`colorStatus${color}Background2`]: _colorPalette.mappedStatusColors[sharedColor].tint40,
        [`colorStatus${color}Background3`]: _colorPalette.mappedStatusColors[sharedColor].primary,
        [`colorStatus${color}Foreground1`]: _colorPalette.mappedStatusColors[sharedColor].shade10,
        [`colorStatus${color}Foreground2`]: _colorPalette.mappedStatusColors[sharedColor].shade30,
        [`colorStatus${color}Foreground3`]: _colorPalette.mappedStatusColors[sharedColor].primary,
        [`colorStatus${color}ForegroundInverted`]: _colorPalette.mappedStatusColors[sharedColor].tint30,
        [`colorStatus${color}BorderActive`]: _colorPalette.mappedStatusColors[sharedColor].primary,
        [`colorStatus${color}Border1`]: _colorPalette.mappedStatusColors[sharedColor].tint40,
        [`colorStatus${color}Border2`]: _colorPalette.mappedStatusColors[sharedColor].primary
    };
    return Object.assign(acc, statusColorTokens);
}, {});
// one-off overrides for colorStatus tokens
colorStatusTokens.colorStatusDangerBackground3Hover = _colorPalette.mappedStatusColors[_statusColorMapping.statusColorMapping.danger].shade10;
colorStatusTokens.colorStatusDangerBackground3Pressed = _colorPalette.mappedStatusColors[_statusColorMapping.statusColorMapping.danger].shade20;
colorStatusTokens.colorStatusWarningForeground1 = _colorPalette.mappedStatusColors[_statusColorMapping.statusColorMapping.warning].shade20;
colorStatusTokens.colorStatusWarningForeground3 = _colorPalette.mappedStatusColors[_statusColorMapping.statusColorMapping.warning].shade20;
colorStatusTokens.colorStatusWarningBorder2 = _colorPalette.mappedStatusColors[_statusColorMapping.statusColorMapping.warning].shade20;
