'use client';
import * as React from 'react';
import { useResizeObserverRef_unstable } from './useResizeObserverRef';
import { useFluent_unstable as useFluent } from '@fluentui/react-shared-contexts';
/**
 * React hook that measures virtualized space based on a static size to ensure optimized virtualization length.
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */ export const useStaticVirtualizerMeasure = (virtualizerProps)=>{
    const { defaultItemSize, direction = 'vertical', bufferItems, bufferSize } = virtualizerProps;
    const [state, setState] = React.useState({
        virtualizerLength: 0,
        _bufferSize: 0,
        _bufferItems: 0
    });
    const containerSizeRef = React.useRef(0);
    const { targetDocument } = useFluent();
    const { virtualizerLength, _bufferItems, _bufferSize } = state;
    const resizeCallback = React.useCallback((_entries, // TODO: exclude types from this lint rule: https://github.com/microsoft/fluentui/issues/31286
    _observer, scrollRef)=>{
        if (!(scrollRef === null || scrollRef === void 0 ? void 0 : scrollRef.current)) {
            return;
        }
        if (scrollRef.current !== (targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.body)) {
            // We have a local scroll container
            containerSizeRef.current = direction === 'vertical' ? scrollRef === null || scrollRef === void 0 ? void 0 : scrollRef.current.getBoundingClientRect().height : scrollRef === null || scrollRef === void 0 ? void 0 : scrollRef.current.getBoundingClientRect().width;
        } else if (targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView) {
            var _targetDocument_defaultView, _targetDocument_defaultView1;
            // If our scroll ref is the document body, we should check window height
            containerSizeRef.current = direction === 'vertical' ? targetDocument === null || targetDocument === void 0 ? void 0 : (_targetDocument_defaultView = targetDocument.defaultView) === null || _targetDocument_defaultView === void 0 ? void 0 : _targetDocument_defaultView.innerHeight : targetDocument === null || targetDocument === void 0 ? void 0 : (_targetDocument_defaultView1 = targetDocument.defaultView) === null || _targetDocument_defaultView1 === void 0 ? void 0 : _targetDocument_defaultView1.innerWidth;
        }
        /*
       * Number of items required to cover viewport.
       */ const length = Math.ceil(containerSizeRef.current / defaultItemSize + 1);
        /*
       * Number of items to append at each end, i.e. 'preload' each side before entering view.
       * Minimum: 1
       */ const newBufferItems = bufferItems !== null && bufferItems !== void 0 ? bufferItems : Math.max(Math.ceil(length / 4), 1);
        /*
       * This is how far we deviate into the bufferItems to detect a redraw.
       */ const newBufferSize = bufferSize !== null && bufferSize !== void 0 ? bufferSize : Math.max(defaultItemSize / 2.0, 1);
        const totalLength = length + newBufferItems * 2;
        setState({
            virtualizerLength: totalLength,
            _bufferItems: newBufferItems,
            _bufferSize: newBufferSize
        });
    }, [
        bufferItems,
        bufferSize,
        defaultItemSize,
        direction,
        targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.body,
        targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView
    ]);
    const scrollRef = useResizeObserverRef_unstable(resizeCallback);
    return {
        virtualizerLength,
        bufferItems: _bufferItems,
        bufferSize: _bufferSize,
        scrollRef,
        containerSizeRef
    };
};
