'use client';
import * as React from 'react';
import { useFluent_unstable as useFluent } from '@fluentui/react-shared-contexts';
import { debounce } from '../utilities/debounce';
import { createResizeObserverFromDocument } from '../utilities/createResizeObserverFromDocument';
/**
 * useResizeObserverRef_unstable simplifies resize observer connection and ensures debounce/cleanup
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */ export const useResizeObserverRef_unstable = (resizeCallback)=>{
    'use no memo';
    const { targetDocument } = useFluent();
    const container = React.useRef(null);
    const containerHeightRef = React.useRef(0);
    const containerWidthRef = React.useRef(0);
    // the handler for resize observer
    // TODO: exclude types from this lint rule: https://github.com/microsoft/fluentui/issues/31286
    const handleResize = debounce((entries, observer)=>{
        var _container_current, _container_current1;
        const containerHeight = (_container_current = container.current) === null || _container_current === void 0 ? void 0 : _container_current.clientHeight;
        const containerWidth = (_container_current1 = container.current) === null || _container_current1 === void 0 ? void 0 : _container_current1.clientWidth;
        // Our resize observer will fire on scroll resize, let index change handle that instead.
        if (containerHeightRef.current !== containerHeight || containerWidth !== containerWidthRef.current) {
            containerWidthRef.current = containerWidth !== null && containerWidth !== void 0 ? containerWidth : 0;
            containerHeightRef.current = containerHeight !== null && containerHeight !== void 0 ? containerHeight : 0;
            resizeCallback(entries, observer, container);
        }
    });
    // Keep the reference of ResizeObserver in the state, as it should live through renders
    const [resizeObserver, setResizeObserver] = React.useState(()=>createResizeObserverFromDocument(targetDocument, handleResize));
    React.useEffect(()=>{
        // Update our state when resizeCallback changes
        container.current = null;
        resizeObserver === null || resizeObserver === void 0 ? void 0 : resizeObserver.disconnect();
        setResizeObserver(()=>createResizeObserverFromDocument(targetDocument, handleResize));
    // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [
        resizeCallback,
        targetDocument
    ]);
    React.useEffect(()=>{
        return ()=>{
            container.current = null;
            resizeObserver === null || resizeObserver === void 0 ? void 0 : resizeObserver.disconnect();
        };
    // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    const scrollRef = React.useCallback((instance)=>{
        if (container.current !== instance) {
            if (container.current) {
                resizeObserver === null || resizeObserver === void 0 ? void 0 : resizeObserver.unobserve(container.current);
            }
            container.current = instance;
            if (container.current) {
                resizeObserver === null || resizeObserver === void 0 ? void 0 : resizeObserver.observe(container.current);
            }
        }
    }, [
        resizeObserver
    ]);
    return scrollRef;
};
