'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useResizeObserverRef_unstable", {
    enumerable: true,
    get: function() {
        return useResizeObserverRef_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _debounce = require("../utilities/debounce");
const _createResizeObserverFromDocument = require("../utilities/createResizeObserverFromDocument");
const useResizeObserverRef_unstable = (resizeCallback)=>{
    'use no memo';
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const container = _react.useRef(null);
    const containerHeightRef = _react.useRef(0);
    const containerWidthRef = _react.useRef(0);
    // the handler for resize observer
    // TODO: exclude types from this lint rule: https://github.com/microsoft/fluentui/issues/31286
    const handleResize = (0, _debounce.debounce)((entries, observer)=>{
        var _container_current, _container_current1;
        const containerHeight = (_container_current = container.current) === null || _container_current === void 0 ? void 0 : _container_current.clientHeight;
        const containerWidth = (_container_current1 = container.current) === null || _container_current1 === void 0 ? void 0 : _container_current1.clientWidth;
        // Our resize observer will fire on scroll resize, let index change handle that instead.
        if (containerHeightRef.current !== containerHeight || containerWidth !== containerWidthRef.current) {
            containerWidthRef.current = containerWidth !== null && containerWidth !== void 0 ? containerWidth : 0;
            containerHeightRef.current = containerHeight !== null && containerHeight !== void 0 ? containerHeight : 0;
            resizeCallback(entries, observer, container);
        }
    });
    // Keep the reference of ResizeObserver in the state, as it should live through renders
    const [resizeObserver, setResizeObserver] = _react.useState(()=>(0, _createResizeObserverFromDocument.createResizeObserverFromDocument)(targetDocument, handleResize));
    _react.useEffect(()=>{
        // Update our state when resizeCallback changes
        container.current = null;
        resizeObserver === null || resizeObserver === void 0 ? void 0 : resizeObserver.disconnect();
        setResizeObserver(()=>(0, _createResizeObserverFromDocument.createResizeObserverFromDocument)(targetDocument, handleResize));
    // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [
        resizeCallback,
        targetDocument
    ]);
    _react.useEffect(()=>{
        return ()=>{
            container.current = null;
            resizeObserver === null || resizeObserver === void 0 ? void 0 : resizeObserver.disconnect();
        };
    // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    const scrollRef = _react.useCallback((instance)=>{
        if (container.current !== instance) {
            if (container.current) {
                resizeObserver === null || resizeObserver === void 0 ? void 0 : resizeObserver.unobserve(container.current);
            }
            container.current = instance;
            if (container.current) {
                resizeObserver === null || resizeObserver === void 0 ? void 0 : resizeObserver.observe(container.current);
            }
        }
    }, [
        resizeObserver
    ]);
    return scrollRef;
};
