'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useMutationObserver", {
    enumerable: true,
    get: function() {
        return useMutationObserver;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const { useRef, useEffect } = _react;
const useMutationObserver = (target, callback, options)=>{
    'use no memo';
    // TODO: exclude types from this lint rule: https://github.com/microsoft/fluentui/issues/31286
    const observer = useRef();
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const win = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView;
    useEffect(()=>{
        if (!win) {
            return;
        }
        // Create an observer instance linked to the callback function
        observer.current = new win.MutationObserver(callback);
    }, [
        callback,
        win
    ]);
    useEffect(()=>{
        if (target) {
            var _observer_current;
            (_observer_current = observer.current) === null || _observer_current === void 0 ? void 0 : _observer_current.observe(target, options);
        }
        return ()=>{
            var _observer_current;
            (_observer_current = observer.current) === null || _observer_current === void 0 ? void 0 : _observer_current.disconnect();
        };
    }, [
        target,
        options
    ]);
    return {
        observer
    };
};
