'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createResizeObserverFromDocument: function() {
        return createResizeObserverFromDocument;
    },
    useMeasureList: function() {
        return useMeasureList;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
function useMeasureList(currentIndex, refLength, totalLength, defaultItemSize) {
    const widthArray = _react.useRef(new Array(totalLength).fill(defaultItemSize));
    const heightArray = _react.useRef(new Array(totalLength).fill(defaultItemSize));
    const refArray = _react.useRef([]);
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    // This lets us trigger updates when a size change occurs.
    const sizeUpdateCount = _react.useRef(0);
    // the handler for resize observer
    const handleIndexUpdate = _react.useCallback((index)=>{
        var _refArray_current_index;
        let isChanged = false;
        const boundClientRect = (_refArray_current_index = refArray.current[index]) === null || _refArray_current_index === void 0 ? void 0 : _refArray_current_index.getBoundingClientRect();
        const containerWidth = boundClientRect === null || boundClientRect === void 0 ? void 0 : boundClientRect.width;
        if (containerWidth !== widthArray.current[currentIndex + index]) {
            isChanged = true;
        }
        widthArray.current[currentIndex + index] = containerWidth || defaultItemSize;
        const containerHeight = boundClientRect === null || boundClientRect === void 0 ? void 0 : boundClientRect.height;
        if (containerHeight !== heightArray.current[currentIndex + index]) {
            isChanged = true;
        }
        heightArray.current[currentIndex + index] = containerHeight || defaultItemSize;
        if (isChanged) {
            sizeUpdateCount.current = sizeUpdateCount.current + 1;
        }
    }, [
        currentIndex,
        defaultItemSize,
        sizeUpdateCount
    ]);
    const handleElementResizeCallback = (entries)=>{
        for (const entry of entries){
            const target = entry.target;
            // Call the elements own resize handler (indexed)
            target.handleResize();
        }
    };
    _react.useEffect(()=>{
        const newHeightLength = totalLength - heightArray.current.length;
        const newWidthLength = totalLength - widthArray.current.length;
        /* Ensure we grow or truncate arrays with prior properties,
    keeping the existing values is important for whitespace assumptions.
    Even if items in the 'middle' are deleted, we will recalc the whitespace as it is explored.*/ if (newWidthLength > 0) {
            widthArray.current = widthArray.current.concat(new Array(newWidthLength).fill(defaultItemSize));
        } else if (newWidthLength < 0) {
            widthArray.current = widthArray.current.slice(0, totalLength);
        }
        if (newHeightLength > 0) {
            heightArray.current = heightArray.current.concat(new Array(newHeightLength).fill(defaultItemSize));
        } else if (newHeightLength < 0) {
            heightArray.current = heightArray.current.slice(0, totalLength);
        }
    }, [
        defaultItemSize,
        totalLength
    ]);
    // Keep the reference of ResizeObserver as a ref, as it should live through renders
    const resizeObserver = _react.useRef(createResizeObserverFromDocument(targetDocument, handleElementResizeCallback));
    /* createIndexedRef provides a dynamic function to create an undefined number of refs at render time
   * these refs then provide an indexed callback via attaching 'handleResize' to the element itself
   * this function is then called on resize by handleElementResize and relies on indexing
   * to track continuous sizes throughout renders while releasing all virtualized element refs each render cycle.
   */ const createIndexedRef = _react.useCallback((index)=>{
        const measureElementRef = (el)=>{
            if (!targetDocument || !resizeObserver.current) {
                return;
            }
            if (el) {
                el.handleResize = ()=>{
                    handleIndexUpdate(index);
                };
            }
            // cleanup previous container
            if (refArray.current[index] !== undefined && refArray.current[index] !== null) {
                resizeObserver.current.unobserve(refArray.current[index]);
            }
            refArray.current[index] = undefined;
            if (el) {
                refArray.current[index] = el;
                resizeObserver.current.observe(el);
                handleIndexUpdate(index);
            }
        };
        return measureElementRef;
    }, [
        handleIndexUpdate,
        resizeObserver,
        targetDocument
    ]);
    _react.useEffect(()=>{
        const _resizeObserver = resizeObserver;
        return ()=>{
            var _resizeObserver_current;
            return (_resizeObserver_current = _resizeObserver.current) === null || _resizeObserver_current === void 0 ? void 0 : _resizeObserver_current.disconnect();
        };
    }, [
        resizeObserver
    ]);
    return {
        widthArray,
        heightArray,
        createIndexedRef,
        refArray,
        sizeUpdateCount: sizeUpdateCount.current
    };
}
function createResizeObserverFromDocument(targetDocument, callback) {
    var _targetDocument_defaultView;
    if (!(targetDocument === null || targetDocument === void 0 ? void 0 : (_targetDocument_defaultView = targetDocument.defaultView) === null || _targetDocument_defaultView === void 0 ? void 0 : _targetDocument_defaultView.ResizeObserver)) {
        return null;
    }
    return new targetDocument.defaultView.ResizeObserver(callback);
}
