'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    useVirtualizerScrollViewStyles_unstable: function() {
        return useVirtualizerScrollViewStyles_unstable;
    },
    virtualizerScrollViewClassNames: function() {
        return virtualizerScrollViewClassNames;
    }
});
const _useVirtualizerStylesstyles = require("../Virtualizer/useVirtualizerStyles.styles");
const _react = require("@griffel/react");
const virtualizerScrollViewClassName = 'fui-Virtualizer-Scroll-View';
const virtualizerScrollViewClassNames = {
    ..._useVirtualizerStylesstyles.virtualizerClassNames,
    container: `${virtualizerScrollViewClassName}__container`
};
const useStyles = (0, _react.makeStyles)({
    base: {
        display: 'flex',
        width: '100%',
        height: '100%'
    },
    vertical: {
        flexDirection: 'column',
        overflowY: 'auto'
    },
    horizontal: {
        flexDirection: 'row',
        overflowX: 'auto'
    },
    verticalReversed: {
        flexDirection: 'column-reverse',
        overflowY: 'auto'
    },
    horizontalReversed: {
        flexDirection: 'row-reverse',
        overflowX: 'auto'
    }
});
const useVirtualizerScrollViewStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    // Default virtualizer styles base
    (0, _useVirtualizerStylesstyles.useVirtualizerStyles_unstable)(state);
    const containerStyle = state.axis === 'horizontal' ? state.reversed ? styles.horizontalReversed : styles.horizontal : state.reversed ? styles.verticalReversed : styles.vertical;
    // Add container styles
    state.container.className = (0, _react.mergeClasses)(virtualizerScrollViewClassNames.container, styles.base, containerStyle, state.container.className);
    return state;
};
