'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useVirtualizerScrollView_unstable", {
    enumerable: true,
    get: function() {
        return useVirtualizerScrollView_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _useVirtualizer = require("../Virtualizer/useVirtualizer");
const _Hooks = require("../../Hooks");
const _Utilities = require("../../Utilities");
const _useStaticPagination = require("../../hooks/useStaticPagination");
function useVirtualizerScrollView_unstable(props) {
    const { imperativeRef, itemSize, numItems, axis = 'vertical', reversed, enablePagination = false } = props;
    var _props_axis;
    const { virtualizerLength, bufferItems, bufferSize, scrollRef, containerSizeRef } = (0, _Hooks.useStaticVirtualizerMeasure)({
        defaultItemSize: props.itemSize,
        direction: (_props_axis = props.axis) !== null && _props_axis !== void 0 ? _props_axis : 'vertical'
    });
    // Store the virtualizer length as a ref for imperative ref access
    const virtualizerLengthRef = _react.useRef(virtualizerLength);
    if (virtualizerLengthRef.current !== virtualizerLength) {
        virtualizerLengthRef.current = virtualizerLength;
    }
    const paginationRef = (0, _useStaticPagination.useStaticVirtualizerPagination)({
        axis,
        itemSize
    }, enablePagination);
    const scrollViewRef = (0, _reactutilities.useMergedRefs)(props.scrollViewRef, scrollRef, paginationRef);
    const imperativeVirtualizerRef = _react.useRef(null);
    const scrollCallbackRef = _react.useRef(null);
    _react.useImperativeHandle(imperativeRef, ()=>{
        var _imperativeVirtualizerRef_current;
        return {
            scrollTo (index, behavior = 'auto', callback) {
                var _imperativeVirtualizerRef_current;
                scrollCallbackRef.current = callback !== null && callback !== void 0 ? callback : null;
                (_imperativeVirtualizerRef_current = imperativeVirtualizerRef.current) === null || _imperativeVirtualizerRef_current === void 0 ? void 0 : _imperativeVirtualizerRef_current.setFlaggedIndex(index);
                (0, _Utilities.scrollToItemStatic)({
                    index,
                    itemSize,
                    totalItems: numItems,
                    scrollViewRef,
                    axis,
                    reversed,
                    behavior
                });
            },
            currentIndex: (_imperativeVirtualizerRef_current = imperativeVirtualizerRef.current) === null || _imperativeVirtualizerRef_current === void 0 ? void 0 : _imperativeVirtualizerRef_current.currentIndex,
            virtualizerLength: virtualizerLengthRef
        };
    }, [
        axis,
        scrollViewRef,
        itemSize,
        numItems,
        reversed
    ]);
    const handleRenderedIndex = (index)=>{
        if (scrollCallbackRef.current) {
            scrollCallbackRef.current(index);
        }
    };
    const virtualizerState = (0, _useVirtualizer.useVirtualizer_unstable)({
        ...props,
        virtualizerLength,
        bufferItems,
        bufferSize,
        onRenderedFlaggedIndex: handleRenderedIndex,
        imperativeVirtualizerRef,
        containerSizeRef
    });
    return {
        ...virtualizerState,
        components: {
            ...virtualizerState.components,
            container: 'div'
        },
        container: _reactutilities.slot.always(props.container, {
            defaultProps: {
                ref: scrollViewRef
            },
            elementType: 'div'
        })
    };
}
