'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    useVirtualizerStyles_unstable: function() {
        return useVirtualizerStyles_unstable;
    },
    virtualizerClassNames: function() {
        return virtualizerClassNames;
    }
});
const _react = require("@griffel/react");
const virtualizerClassName = 'fui-Virtualizer';
const virtualizerClassNames = {
    before: `${virtualizerClassName}__before`,
    beforeContainer: `${virtualizerClassName}__beforeContainer`,
    after: `${virtualizerClassName}__after`,
    afterContainer: `${virtualizerClassName}__afterContainer`
};
const useStyles = /*#__PURE__*/ (0, _react.__styles)({
    base: {
        mc9l5x: "ftgm304",
        Bkecrkj: "f1aehjj5"
    },
    relative: {
        qhf8xq: "f10pi13n"
    },
    horizontal: {
        sshi5w: "fan4evk"
    },
    vertical: {
        Bf4jedk: "f11qra4b"
    }
}, {
    d: [
        ".ftgm304{display:block;}",
        ".f1aehjj5{pointer-events:none;}",
        ".f10pi13n{position:relative;}",
        ".fan4evk{min-height:100%;}",
        ".f11qra4b{min-width:100%;}"
    ]
});
const useVirtualizerStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const { reversed, axis, beforeBufferHeight, afterBufferHeight, bufferSize } = state;
    const horizontal = axis === 'horizontal';
    state.before.className = (0, _react.mergeClasses)(virtualizerClassNames.before, styles.base, styles.relative, horizontal ? styles.horizontal : styles.vertical, state.before.className);
    state.after.className = (0, _react.mergeClasses)(virtualizerClassNames.after, styles.base, styles.relative, horizontal ? styles.horizontal : styles.vertical, state.after.className);
    state.beforeContainer.className = (0, _react.mergeClasses)(virtualizerClassNames.beforeContainer, styles.base, horizontal ? styles.horizontal : styles.vertical, state.beforeContainer.className);
    state.afterContainer.className = (0, _react.mergeClasses)(virtualizerClassNames.afterContainer, styles.base, horizontal ? styles.horizontal : styles.vertical, state.afterContainer.className);
    const beforeHeightPx = beforeBufferHeight + 'px';
    const afterHeightPx = afterBufferHeight + 'px';
    const beforeBufferHeightPx = beforeBufferHeight + bufferSize + 'px';
    const afterBufferHeightPx = afterBufferHeight + bufferSize + 'px';
    const bufferPx = bufferSize + 'px';
    const beforeBuffer = {
        // Column
        ...!reversed && !horizontal && {
            marginBottom: `-${bufferPx}`
        },
        // Column-Reverse
        ...reversed && !horizontal && {
            marginTop: `-${bufferPx}`
        },
        // Row
        ...!reversed && horizontal && {
            marginRight: `-${bufferPx}`
        },
        // Row-Reverse
        ...reversed && horizontal && {
            marginLeft: `-${bufferPx}`
        }
    };
    const afterBuffer = {
        // Column
        ...!reversed && !horizontal && {
            marginTop: `-${bufferPx}`
        },
        // Column-Reverse
        ...reversed && !horizontal && {
            marginBottom: `-${bufferPx}`
        },
        // Row
        ...!reversed && horizontal && {
            marginLeft: `-${bufferPx}`
        },
        // Row-Reverse
        ...reversed && horizontal && {
            marginRight: `-${bufferPx}`
        }
    };
    state.before.style = {
        height: horizontal ? '100%' : beforeBufferHeightPx,
        width: horizontal ? beforeBufferHeightPx : '100%',
        ...beforeBuffer,
        ...state.before.style
    };
    state.beforeContainer.style = {
        height: horizontal ? 'auto' : beforeHeightPx,
        width: horizontal ? beforeHeightPx : 'auto',
        ...state.beforeContainer.style
    };
    state.after.style = {
        height: horizontal ? '100%' : afterBufferHeightPx,
        width: horizontal ? afterBufferHeightPx : '100%',
        ...afterBuffer,
        ...state.after.style
    };
    state.afterContainer.style = {
        height: horizontal ? 'auto' : afterHeightPx,
        width: horizontal ? afterHeightPx : 'auto',
        ...state.afterContainer.style
    };
    return state;
};
