import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Some props are optional on static virtualizer, but required for dynamic.
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type DynamicVirtualizerContextProps = Required<VirtualizerContextProps>;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare interface IndexedResizeCallbackElement {
    handleResize: () => void;
}

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const renderVirtualizer_unstable: (state: VirtualizerState) => React_2.ReactElement;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const renderVirtualizerScrollView_unstable: (state: VirtualizerScrollViewState) => React_2.ReactElement;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const renderVirtualizerScrollViewDynamic_unstable: (state: VirtualizerScrollViewDynamicState) => React_2.ReactElement;

/**
 * Additional direct Ref prevents reading old resize entry data
 * Backwards compatible with ResizeObserverCallback if preferred
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare interface ResizeCallbackWithRef {
    (entries: ResizeObserverEntry[], observer: ResizeObserver, scrollRef?: React_2.MutableRefObject<HTMLElement | null>): void;
}

export declare type ScrollToInterface = {
    scrollTo: (index: number, behavior?: ScrollBehavior, callback?: (index: number) => void) => void;
    virtualizerLength: React_2.RefObject<number>;
    currentIndex: React_2.RefObject<number> | undefined;
};

export declare const scrollToItemDynamic: (params: ScrollToItemDynamicParams) => void;

export declare type ScrollToItemDynamicParams = {
    index: number;
    itemSizes: React_2.RefObject<number[]>;
    totalSize: number;
    scrollViewRef: React_2.RefObject<HTMLDivElement>;
    axis?: 'horizontal' | 'vertical';
    reversed?: boolean;
    behavior?: ScrollBehavior;
};

export declare const scrollToItemStatic: (params: ScrollToItemStaticParams) => void;

export declare type ScrollToItemStaticParams = {
    index: number;
    itemSize: number;
    totalItems: number;
    scrollViewRef: React_2.RefObject<HTMLDivElement>;
    axis?: 'horizontal' | 'vertical';
    reversed?: boolean;
    behavior?: ScrollBehavior;
};

/**
 * React hook that measures virtualized space dynamically to ensure optimized virtualization length.
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const useDynamicVirtualizerMeasure: <TElement extends HTMLElement>(virtualizerProps: VirtualizerMeasureDynamicProps) => {
    virtualizerLength: number;
    bufferItems: number;
    bufferSize: number;
    scrollRef: (instance: TElement | null) => void;
    containerSizeRef: React_2.RefObject<number>;
    updateScrollPosition: (scrollPosition: number) => void;
};

/**
 * React hook that allows easy usage of the browser API IntersectionObserver within React
 * @param callback - A function called when the percentage of the target element is visible crosses a threshold.
 * @param options - An optional object which customizes the observer. If options isn't specified, the observer uses the
 * document's viewport as the root, with no margin, and a 0% threshold (meaning that even a one-pixel change is
 * enough to trigger a callback).
 * @returns An array containing a callback to update the list of Elements the observer should listen to, a callback to
 * update the init options of the IntersectionObserver and a ref to the IntersectionObserver instance itself.
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const useIntersectionObserver: (callback: IntersectionObserverCallback, options?: IntersectionObserverInit) => {
    setObserverList: React_2.Dispatch<React_2.SetStateAction<Element[] | undefined>>;
    setObserverInit: (newInit: IntersectionObserverInit | undefined) => void;
    observer: React_2.MutableRefObject<IntersectionObserver | undefined>;
};

/**
 * Provides a way of automating size in the virtualizer
 * Returns
 * `width` - element width ref (0 by default),
 * `height` - element height ref (0 by default),
 * `measureElementRef` - a ref function to be passed as `ref` to the element you want to measure
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare function useMeasureList<TElement extends HTMLElement & IndexedResizeCallbackElement = HTMLElement & IndexedResizeCallbackElement>(currentIndex: number, refLength: number, totalLength: number, defaultItemSize: number): {
    widthArray: React_2.MutableRefObject<number[]>;
    heightArray: React_2.MutableRefObject<number[]>;
    createIndexedRef: (index: number) => (el: TElement | null) => void;
    refArray: React_2.MutableRefObject<Array<TElement | undefined | null>>;
    sizeUpdateCount: number;
};

/**
 * useResizeObserverRef_unstable simplifies resize observer connection and ensures debounce/cleanup
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const useResizeObserverRef_unstable: (resizeCallback: ResizeCallbackWithRef) => ((instance: HTMLElement | HTMLDivElement | null) => void);

/**
 * React hook that measures virtualized space based on a static size to ensure optimized virtualization length.
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const useStaticVirtualizerMeasure: <TElement extends HTMLElement>(virtualizerProps: VirtualizerMeasureProps) => {
    virtualizerLength: number;
    bufferItems: number;
    bufferSize: number;
    scrollRef: (instance: TElement | null) => void;
    containerSizeRef: React_2.MutableRefObject<number>;
};

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare function useVirtualizer_unstable(props: VirtualizerProps): VirtualizerState;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const useVirtualizerContext_unstable: () => VirtualizerContextProps;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare function useVirtualizerScrollView_unstable(props: VirtualizerScrollViewProps): VirtualizerScrollViewState;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare function useVirtualizerScrollViewDynamic_unstable(props: VirtualizerScrollViewDynamicProps): VirtualizerScrollViewDynamicState;

/**
 * Apply styling to the Virtualizer states
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const useVirtualizerScrollViewDynamicStyles_unstable: (state: VirtualizerScrollViewDynamicState) => VirtualizerScrollViewDynamicState;

/**
 * Apply styling to the Virtualizer states
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const useVirtualizerScrollViewStyles_unstable: (state: VirtualizerScrollViewState) => VirtualizerScrollViewState;

/**
 * Apply styling to the Virtualizer states
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const useVirtualizerStyles_unstable: (state: VirtualizerState) => VirtualizerState;

/**
 * Virtualizer pseudo-component, this functional wrapper
 * provides a simple interface for reducing the total number
 * of elements rendered at one time in large lists.
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const Virtualizer: React_2.FC<VirtualizerProps>;

/**
 * The main child render method of Virtualization
 * isScrolling will only be enabled when enableScrollLoad is set to true.
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerChildRenderFunction = (index: number, isScrolling: boolean) => React_2.ReactNode;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const virtualizerClassNames: SlotClassNames<VirtualizerSlots>;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
declare type VirtualizerConfigProps = {
    /**
     * Child render function.
     * Iteratively called to return current virtualizer DOM children.
     * Will act as a row or column indexer depending on Virtualizer settings.
     * Can be used dynamically.
     */
    children: VirtualizerChildRenderFunction;
    /**
     * Default cell size to use if no custom callback provided.
     * If implementing `getItemSize` this should be the initial and ideally minimum cell size.
     */
    itemSize: number;
    /**
     * The total number of items to be virtualized.
     */
    numItems: number;
    /**
     * Number of children to render in the DOM during virtualization.
     * Constraints:
     * - Large enough that the items rendered in DOM cover the viewport
     *   and intersection observer buffers (buffersize) at both ends.
     */
    virtualizerLength: number;
    /**
     * Defaults to 1/4th (or 1/3rd for dynamic items) of virtualizerLength.
     * RECOMMEND: Override this with a consistent value if using a dynamic virtualizer.
     *
     * Controls the number of elements rendered before the current index entering the virtualized viewport.
     * Constraints:
     * - Large enough to cover bufferSize (prevents buffers intersecting into the viewport during rest state).
     * - Small enough that the virtualizer only renders a few items outside of view.
     */
    bufferItems?: number;
    /**
     * Defaults to half of bufferItems * itemSize size (in pixels).
     * RECOMMEND: Override this with a consistent minimum item size value if using a dynamic virtualizer.
     * The length (in pixels) before the end/start DOM index where the virtualizer recalculation will be triggered.
     * Increasing this reduces whitespace on ultra-fast scroll, as additional elements
     * are buffered to appear while virtualization recalculates.
     * Constraints:
     * - At least 1px - although this will only trigger the recalculation after bookends (whitespace) enter viewport.
     * - BufferSize must be smaller than bufferItems pixel size, as it prevents bookends entering viewport at rest.
     */
    bufferSize?: number;
    /**
     * Enables users to override the intersectionObserverRoot.
     * We recommend passing this in for accurate distance assessment in IO
     */
    scrollViewRef?: React_2.MutableRefObject<HTMLElement | null>;
    /**
     * The scroll direction
     * @default vertical
     */
    axis?: 'vertical' | 'horizontal';
    /**
     * Tells the virtualizer to measure in the reverse direction (for column-reverse order etc.)
     * This value should be flipped in RTL implementation (TBD whether automate RTL).
     */
    reversed?: boolean;
    /**
     * Enables the isScrolling property in the child render function
     * Default: false - to prevent nessecary render function calls
     */
    enableScrollLoad?: boolean;
    /**
     * Callback for acquiring size of individual items
     * @param index - the index of the requested size's child
     */
    getItemSize?: (index: number) => number;
    /**
     * Virtualizer context can be passed as a prop for extended class use
     */
    virtualizerContext?: VirtualizerContextProps;
    /**
     * Callback for notifying when a flagged index has been rendered
     */
    onRenderedFlaggedIndex?: (index: number) => void;
    flaggedIndex?: React_2.MutableRefObject<number | null>;
    /**
     * Imperative ref contains our scrollTo index functionality for user control.
     */
    imperativeVirtualizerRef?: React_2.RefObject<VirtualizerDataRef | null>;
    /**
     * A ref that provides the size of container (vertical - height, horizontal - width), set by a resize observer.
     * Virtualizer Measure hooks provide a suitable reference.
     */
    containerSizeRef: React_2.RefObject<number>;
    /**
     * A callback that enables updating scroll position for calculating required dynamic lengths,
     * this should be passed in from useDynamicVirtualizerMeasure
     */
    updateScrollPosition?: (position: number) => void;
    /**
     * Spacing between rendered children for calculation, should match the container's gap CSS value.
     */
    gap?: number;
};

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
declare type VirtualizerConfigState = {
    /**
     * The current virtualized array of children to show in the DOM.
     */
    virtualizedChildren: React_2.ReactNode[];
    /**
     * The current start index for the virtualizer, all previous index's will be removed from DOM.
     */
    virtualizerStartIndex: number;
    /**
     * Current buffer height required at beginning of array.
     */
    afterBufferHeight: number;
    /**
     * Current buffer height required at end of array.
     */
    beforeBufferHeight: number;
    /**
     * The total current height of the scrollView/child content.
     */
    totalVirtualizerHeight: number;
    /**
     * The scroll direction
     * @default vertical
     */
    axis?: 'vertical' | 'horizontal';
    /**
     * Tells the virtualizer to measure in the reverse direction (for column-reverse order etc.)
     */
    reversed?: boolean;
    /**
     * Enables the isScrolling property in the child render function
     * Default: false - to prevent nessecary render function calls
     */
    enableScrollLoad?: boolean;
    /**
     * Pixel size of intersection observers and how much they 'cross over' into the bufferItems index.
     * Minimum 1px.
     */
    bufferSize: number;
    /**
     * Ref for access to internal size knowledge, can be used to measure updates
     */
    childSizes: React_2.MutableRefObject<number[]>;
    /**
     * Ref for access to internal progressive size knowledge, can be used to measure updates
     */
    childProgressiveSizes: React_2.MutableRefObject<number[]>;
};

/**
 * {@docCategory Virtualizer}
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerContextProps = {
    contextIndex: number;
    setContextIndex: (index: number) => void;
    childProgressiveSizes?: React_2.MutableRefObject<number[]>;
};

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const VirtualizerContextProvider: React_2.Provider<VirtualizerContextProps>;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerDataRef = {
    progressiveSizes: React_2.RefObject<number[]>;
    nodeSizes: React_2.RefObject<number[]>;
    setFlaggedIndex: (index: number | null) => void;
    currentIndex: React_2.RefObject<number>;
};

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerMeasureDynamicProps = {
    defaultItemSize: number;
    virtualizerContext: DynamicVirtualizerContextProps;
    numItems: number;
    getItemSize: (index: number) => number;
    direction?: 'vertical' | 'horizontal';
    /**
     * Override recommended number of buffer items
     */
    bufferItems?: number;
    /**
     * Override recommended buffer size (px)
     */
    bufferSize?: number;
};

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerMeasureProps = {
    defaultItemSize: number;
    direction?: 'vertical' | 'horizontal';
    /**
     * Override recommended number of buffer items
     */
    bufferItems?: number;
    /**
     * Override recommended buffer size (px)
     */
    bufferSize?: number;
};

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerProps = ComponentProps<Partial<VirtualizerSlots>> & VirtualizerConfigProps;

/**
 * Virtualizer ScrollView
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const VirtualizerScrollView: React_2.FC<VirtualizerScrollViewProps>;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const virtualizerScrollViewClassNames: SlotClassNames<VirtualizerScrollViewSlots>;

/**
 * Virtualizer ScrollView
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const VirtualizerScrollViewDynamic: React_2.FC<VirtualizerScrollViewDynamicProps>;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare const virtualizerScrollViewDynamicClassNames: SlotClassNames<VirtualizerScrollViewDynamicSlots>;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerScrollViewDynamicProps = ComponentProps<Partial<VirtualizerScrollViewDynamicSlots>> & Partial<Omit<VirtualizerConfigProps, 'itemSize' | 'numItems' | 'getItemSize' | 'children' | 'flagIndex' | 'virtualizerContext'>> & {
    /**
     * Set as the minimum item size.
     * Axis: 'vertical' = Height
     * Axis: 'horizontal' = Width
     */
    itemSize: number;
    /**
     * Callback for acquiring size of individual items
     * @param index - the index of the requested size's child
     * If undefined, Virtualizer will auto-measure by default (performance tradeoff)
     */
    getItemSize?: (index: number) => number;
    /**
     * The total number of items to be virtualized.
     */
    numItems: number;
    /**
     * Child render function.
     * Iteratively called to return current virtualizer DOM children.
     * Will act as a row or column indexer depending on Virtualizer settings.
     */
    children: VirtualizerChildRenderFunction;
    /**
     * Imperative ref contains our scrollTo index functionality for user control.
     */
    imperativeRef?: React_2.RefObject<ScrollToInterface | null>;
    /**
     * Imperative ref contains our scrollTo index functionality for user control.
     */
    enablePagination?: boolean;
    /**
     * Enables override of dynamic virtualizer context if required.
     */
    virtualizerContext?: DynamicVirtualizerContextProps;
};

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerScrollViewDynamicSlots = VirtualizerScrollViewSlots;

export declare type VirtualizerScrollViewDynamicState = ComponentState<VirtualizerScrollViewDynamicSlots> & VirtualizerConfigState;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerScrollViewProps = ComponentProps<Partial<VirtualizerScrollViewSlots>> & Partial<Omit<VirtualizerConfigProps, 'itemSize' | 'numItems' | 'getItemSize' | 'children' | 'flagIndex' | 'imperativeVirtualizerRef'>> & {
    /**
     * Virtualizer item size in pixels - static.
     * Axis: 'vertical' = Height
     * Axis: 'horizontal' = Width
     */
    itemSize: number;
    /**
     * The total number of items to be virtualized.
     */
    numItems: number;
    /**
     * Child render function.
     * Iteratively called to return current virtualizer DOM children.
     * Will act as a row or column indexer depending on Virtualizer settings.
     */
    children: VirtualizerChildRenderFunction;
    /**
     * Imperative ref contains our scrollTo index functionality for user control.
     */
    imperativeRef?: React_2.RefObject<ScrollToInterface | null>;
    /**
     * Imperative ref contains our scrollTo index functionality for user control.
     */
    enablePagination?: boolean;
};

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerScrollViewSlots = VirtualizerSlots & {
    /**
     * The root container that provides embedded scrolling.
     */
    container: NonNullable<Slot<'div'>>;
};

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerScrollViewState = ComponentState<VirtualizerScrollViewSlots> & VirtualizerConfigState;

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerSlots = {
    /**
     * The intersection observed 'before' element will detect when scrolling towards the beginning.
     */
    before: NonNullable<Slot<'div', 'td'>>;
    /**
     * A block place holding whitespace at the beginning of current DOM children.
     */
    beforeContainer: NonNullable<Slot<'div', 'tr'>>;
    /**
     * The intersection observed 'after' element will detect when scrolling towards the end.
     */
    after: NonNullable<Slot<'div', 'td'>>;
    /**
     * A block place holding whitespace after the end of current DOM children.
     */
    afterContainer: NonNullable<Slot<'div', 'tr'>>;
};

/**
 * @deprecated migrated to \@fluentui\-contrib/react\-virtualizer for stable release.
 */
export declare type VirtualizerState = ComponentState<VirtualizerSlots> & VirtualizerConfigState;

export { }
