import * as React from 'react';
/**
 * React.SyntheticEvent contains name of a callback that should be fired, this function returns it.
 *
 * Ideally, it should also distinguish regular and "capture" callbacks, but it's possible only with React 17 as
 * ".eventPhase" there has proper value, see https://github.com/facebook/react/pull/19244. In React 16 all events
 * are handled in bubble phase.
 */ export function getReactCallbackName(event) {
    if (event._reactName) {
        return event._reactName;
    }
    if (event.dispatchConfig) {
        if (event.dispatchConfig.registrationName) {
            return event.dispatchConfig.registrationName;
        }
        return event.dispatchConfig.phasedRegistrationNames.bubbled;
    }
    if (process.env.NODE_ENV !== 'production') {
        // eslint-disable-next-line no-console
        console.error(`@fluentui/react-utilities [${getReactCallbackName.name}]:
Passed React.SyntheticEvent does not contain ".dispatchConfig" or "._reactName". This should not happen, please report it to https://github.com/microsoft/fluentui.`);
    }
}
