/**
 * Sets the virtual parent of an element.
 *
 * @internal
 * @param child - Theme element to set the virtual parent
 * @param parent - The virtual parent, use `undefined` to remove a virtual parent relationship
 */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "setVirtualParent", {
    enumerable: true,
    get: function() {
        return setVirtualParent;
    }
});
function setVirtualParent(child, parent) {
    if (!child) {
        return;
    }
    Object.assign(child, {
        _virtual: {
            parent
        }
    });
}
