"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "elementContains", {
    enumerable: true,
    get: function() {
        return elementContains;
    }
});
const _getParent = require("./getParent");
function elementContains(parent, child) {
    if (!parent || !child) {
        return false;
    }
    if (parent === child) {
        return true;
    } else {
        // Tracks references of nodes that have been visited to prevent infinite loops
        const set = new WeakSet();
        while(child){
            const nextParent = (0, _getParent.getParent)(child, {
                skipVirtual: set.has(child)
            });
            set.add(child);
            if (nextParent === parent) {
                return true;
            }
            child = nextParent;
        }
    }
    return false;
}
