"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    anchorProperties: function() {
        return anchorProperties;
    },
    audioProperties: function() {
        return audioProperties;
    },
    baseElementEvents: function() {
        return baseElementEvents;
    },
    baseElementProperties: function() {
        return baseElementProperties;
    },
    buttonProperties: function() {
        return buttonProperties;
    },
    colGroupProperties: function() {
        return colGroupProperties;
    },
    colProperties: function() {
        return colProperties;
    },
    dialogProperties: function() {
        return dialogProperties;
    },
    divProperties: function() {
        return divProperties;
    },
    fieldsetProperties: function() {
        return fieldsetProperties;
    },
    formProperties: function() {
        return formProperties;
    },
    getNativeProps: function() {
        return getNativeProps;
    },
    htmlElementProperties: function() {
        return htmlElementProperties;
    },
    iframeProperties: function() {
        return iframeProperties;
    },
    imgProperties: function() {
        return imgProperties;
    },
    inputProperties: function() {
        return inputProperties;
    },
    labelProperties: function() {
        return labelProperties;
    },
    liProperties: function() {
        return liProperties;
    },
    microdataProperties: function() {
        return microdataProperties;
    },
    olProperties: function() {
        return olProperties;
    },
    optionProperties: function() {
        return optionProperties;
    },
    selectProperties: function() {
        return selectProperties;
    },
    tableProperties: function() {
        return tableProperties;
    },
    tdProperties: function() {
        return tdProperties;
    },
    textAreaProperties: function() {
        return textAreaProperties;
    },
    thProperties: function() {
        return thProperties;
    },
    timeProperties: function() {
        return timeProperties;
    },
    trProperties: function() {
        return trProperties;
    },
    videoProperties: function() {
        return videoProperties;
    }
});
const toObjectMap = (...items)=>{
    const result = {};
    for (const item of items){
        const keys = Array.isArray(item) ? item : Object.keys(item);
        for (const key of keys){
            result[key] = 1;
        }
    }
    return result;
};
const baseElementEvents = toObjectMap([
    'onAuxClick',
    'onAnimationEnd',
    'onAnimationStart',
    'onCopy',
    'onCut',
    'onPaste',
    'onCompositionEnd',
    'onCompositionStart',
    'onCompositionUpdate',
    'onFocus',
    'onFocusCapture',
    'onBlur',
    'onBlurCapture',
    'onChange',
    'onInput',
    'onSubmit',
    'onLoad',
    'onError',
    'onKeyDown',
    'onKeyDownCapture',
    'onKeyPress',
    'onKeyUp',
    'onAbort',
    'onCanPlay',
    'onCanPlayThrough',
    'onDurationChange',
    'onEmptied',
    'onEncrypted',
    'onEnded',
    'onLoadedData',
    'onLoadedMetadata',
    'onLoadStart',
    'onPause',
    'onPlay',
    'onPlaying',
    'onProgress',
    'onRateChange',
    'onSeeked',
    'onSeeking',
    'onStalled',
    'onSuspend',
    'onTimeUpdate',
    'onVolumeChange',
    'onWaiting',
    'onClick',
    'onClickCapture',
    'onContextMenu',
    'onDoubleClick',
    'onDrag',
    'onDragEnd',
    'onDragEnter',
    'onDragExit',
    'onDragLeave',
    'onDragOver',
    'onDragStart',
    'onDrop',
    'onMouseDown',
    'onMouseDownCapture',
    'onMouseEnter',
    'onMouseLeave',
    'onMouseMove',
    'onMouseOut',
    'onMouseOver',
    'onMouseUp',
    'onMouseUpCapture',
    'onSelect',
    'onTouchCancel',
    'onTouchEnd',
    'onTouchMove',
    'onTouchStart',
    'onScroll',
    'onWheel',
    'onPointerCancel',
    'onPointerDown',
    'onPointerEnter',
    'onPointerLeave',
    'onPointerMove',
    'onPointerOut',
    'onPointerOver',
    'onPointerUp',
    'onGotPointerCapture',
    'onLostPointerCapture'
]);
const baseElementProperties = toObjectMap([
    'accessKey',
    'children',
    'className',
    'contentEditable',
    'dir',
    'draggable',
    'hidden',
    'htmlFor',
    'id',
    'lang',
    'ref',
    'role',
    'style',
    'tabIndex',
    'title',
    'translate',
    'spellCheck',
    'name'
]);
const microdataProperties = toObjectMap([
    'itemID',
    'itemProp',
    'itemRef',
    'itemScope',
    'itemType'
]);
const htmlElementProperties = toObjectMap(baseElementProperties, baseElementEvents, microdataProperties);
const labelProperties = toObjectMap(htmlElementProperties, [
    'form'
]);
const audioProperties = toObjectMap(htmlElementProperties, [
    'height',
    'loop',
    'muted',
    'preload',
    'src',
    'width'
]);
const videoProperties = toObjectMap(audioProperties, [
    'poster'
]);
const olProperties = toObjectMap(htmlElementProperties, [
    'start'
]);
const liProperties = toObjectMap(htmlElementProperties, [
    'value'
]);
const anchorProperties = toObjectMap(htmlElementProperties, [
    'download',
    'href',
    'hrefLang',
    'media',
    'referrerPolicy',
    'rel',
    'target',
    'type'
]);
const timeProperties = toObjectMap(htmlElementProperties, [
    'dateTime'
]);
const buttonProperties = toObjectMap(htmlElementProperties, [
    'autoFocus',
    'disabled',
    'form',
    'formAction',
    'formEncType',
    'formMethod',
    'formNoValidate',
    'formTarget',
    'type',
    'value'
]);
const inputProperties = toObjectMap(buttonProperties, [
    'accept',
    'alt',
    'autoCorrect',
    'autoCapitalize',
    'autoComplete',
    'checked',
    'dirname',
    'form',
    'height',
    'inputMode',
    'list',
    'max',
    'maxLength',
    'min',
    'minLength',
    'multiple',
    'pattern',
    'placeholder',
    'readOnly',
    'required',
    'src',
    'step',
    'size',
    'type',
    'value',
    'width'
]);
const textAreaProperties = toObjectMap(buttonProperties, [
    'autoCapitalize',
    'cols',
    'dirname',
    'form',
    'maxLength',
    'placeholder',
    'readOnly',
    'required',
    'rows',
    'wrap'
]);
const selectProperties = toObjectMap(buttonProperties, [
    'form',
    'multiple',
    'required'
]);
const optionProperties = toObjectMap(htmlElementProperties, [
    'selected',
    'value'
]);
const tableProperties = toObjectMap(htmlElementProperties, [
    'cellPadding',
    'cellSpacing'
]);
const trProperties = htmlElementProperties;
const thProperties = toObjectMap(htmlElementProperties, [
    'colSpan',
    'rowSpan',
    'scope'
]);
const tdProperties = toObjectMap(htmlElementProperties, [
    'colSpan',
    'headers',
    'rowSpan',
    'scope'
]);
const colGroupProperties = toObjectMap(htmlElementProperties, [
    'span'
]);
const colProperties = toObjectMap(htmlElementProperties, [
    'span'
]);
const fieldsetProperties = toObjectMap(htmlElementProperties, [
    'disabled',
    'form'
]);
const formProperties = toObjectMap(htmlElementProperties, [
    'acceptCharset',
    'action',
    'encType',
    'encType',
    'method',
    'noValidate',
    'target'
]);
const iframeProperties = toObjectMap(htmlElementProperties, [
    'allow',
    'allowFullScreen',
    'allowPaymentRequest',
    'allowTransparency',
    'csp',
    'height',
    'importance',
    'referrerPolicy',
    'sandbox',
    'src',
    'srcDoc',
    'width'
]);
const imgProperties = toObjectMap(htmlElementProperties, [
    'alt',
    'crossOrigin',
    'height',
    'src',
    'srcSet',
    'useMap',
    'width'
]);
const dialogProperties = toObjectMap(htmlElementProperties, [
    'open',
    'onCancel',
    'onClose'
]);
const divProperties = htmlElementProperties;
function getNativeProps(// eslint-disable-next-line @typescript-eslint/no-explicit-any
props, allowedPropNames, excludedPropNames) {
    // It'd be great to properly type this while allowing 'aria-` and 'data-' attributes like TypeScript does for
    // JSX attributes, but that ability is hardcoded into the TS compiler with no analog in TypeScript typings.
    // Then we'd be able to enforce props extends native props (including aria- and data- attributes), and then
    // return native props.
    // We should be able to do this once this PR is merged: https://github.com/microsoft/TypeScript/pull/26797
    const isArray = Array.isArray(allowedPropNames);
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const result = {};
    const keys = Object.keys(props);
    for (const key of keys){
        const isNativeProp = !isArray && allowedPropNames[key] || isArray && allowedPropNames.indexOf(key) >= 0 || key.indexOf('data-') === 0 || key.indexOf('aria-') === 0;
        if (isNativeProp && (!excludedPropNames || (excludedPropNames === null || excludedPropNames === void 0 ? void 0 : excludedPropNames.indexOf(key)) === -1)) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            result[key] = props[key];
        }
    }
    return result;
}
