"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getNativeElementProps: function() {
        return getNativeElementProps;
    },
    getPartitionedNativeProps: function() {
        return getPartitionedNativeProps;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _properties = require("./properties");
const nativeElementMap = {
    label: _properties.labelProperties,
    audio: _properties.audioProperties,
    video: _properties.videoProperties,
    ol: _properties.olProperties,
    li: _properties.liProperties,
    a: _properties.anchorProperties,
    button: _properties.buttonProperties,
    input: _properties.inputProperties,
    textarea: _properties.textAreaProperties,
    select: _properties.selectProperties,
    option: _properties.optionProperties,
    table: _properties.tableProperties,
    tr: _properties.trProperties,
    th: _properties.thProperties,
    td: _properties.tdProperties,
    colGroup: _properties.colGroupProperties,
    col: _properties.colProperties,
    fieldset: _properties.fieldsetProperties,
    form: _properties.formProperties,
    iframe: _properties.iframeProperties,
    img: _properties.imgProperties,
    time: _properties.timeProperties,
    dialog: _properties.dialogProperties
};
function getNativeElementProps(tagName, props, excludedPropNames) {
    const allowedPropNames = tagName && nativeElementMap[tagName] || _properties.htmlElementProperties;
    allowedPropNames.as = 1;
    return (0, _properties.getNativeProps)(props, allowedPropNames, excludedPropNames);
}
const getPartitionedNativeProps = ({ primarySlotTagName, props, excludedPropNames })=>{
    return {
        root: {
            style: props.style,
            className: props.className
        },
        // eslint-disable-next-line @typescript-eslint/no-deprecated
        primary: getNativeElementProps(primarySlotTagName, props, [
            ...excludedPropNames || [],
            'style',
            'className'
        ])
    };
};
