"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "applyTriggerPropsToChildren", {
    enumerable: true,
    get: function() {
        return applyTriggerPropsToChildren;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _isFluentTrigger = require("./isFluentTrigger");
function applyTriggerPropsToChildren(children, triggerChildProps) {
    if (typeof children === 'function') {
        return children(triggerChildProps);
    } else if (children) {
        return cloneTriggerTree(children, triggerChildProps);
    }
    // Components in React should return either JSX elements or "null", otherwise React will throw:
    //   Nothing was returned from render.
    //   This usually means a return statement is missing. Or, to render nothing, return null.
    return children || null;
}
/**
 * Clones a React element tree, and applies the given props to the first grandchild that is not
 * a FluentTriggerComponent or React Fragment (the same element returned by {@link getTriggerChild}).
 */ function cloneTriggerTree(child, triggerProps) {
    if (!_react.isValidElement(child) || child.type === _react.Fragment) {
        throw new Error('A trigger element must be a single element for this component. ' + "Please ensure that you're not using React Fragments.");
    }
    if ((0, _isFluentTrigger.isFluentTrigger)(child)) {
        const grandchild = cloneTriggerTree(child.props.children, triggerProps);
        return _react.cloneElement(child, undefined, grandchild);
    } else {
        return _react.cloneElement(child, triggerProps);
    }
}
