'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    SSRContext: function() {
        return SSRContext;
    },
    SSRProvider: function() {
        return SSRProvider;
    },
    defaultSSRContextValue: function() {
        return defaultSSRContextValue;
    },
    useIsSSR: function() {
        return useIsSSR;
    },
    useSSRContext: function() {
        return useSSRContext;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _canUseDOM = require("./canUseDOM");
const defaultSSRContextValue = {
    current: 0
};
const SSRContext = /*#__PURE__*/ _react.createContext(undefined);
function useSSRContext() {
    var _React_useContext;
    return (_React_useContext = _react.useContext(SSRContext)) !== null && _React_useContext !== void 0 ? _React_useContext : defaultSSRContextValue;
}
const SSRProvider = (props)=>{
    const [value] = _react.useState(()=>({
            current: 0
        }));
    return /*#__PURE__*/ _react.createElement(SSRContext.Provider, {
        value: value
    }, props.children);
};
function useIsSSR() {
    const isInSSRContext = useSSRContext() !== defaultSSRContextValue;
    const [isSSR, setIsSSR] = _react.useState(isInSSRContext);
    // If we are rendering in a non-DOM environment, and there's no SSRProvider, provide a warning to hint to the
    // developer to add one.
    if (process.env.NODE_ENV !== 'production') {
        if (!isInSSRContext && !(0, _canUseDOM.canUseDOM)()) {
            // eslint-disable-next-line no-console
            console.error(`@fluentui/react-components [${useIsSSR.name}]:
When server rendering, you must wrap your application in an <SSRProvider> to ensure consistent ids are generated between the client and server.


Check documentation at https://aka.ms/fluentui-ssr.`);
        }
    }
    // If on the client, and the component was initially server rendered, then schedule a layout effect to update the
    // component after hydration.
    if ((0, _canUseDOM.canUseDOM)() && isInSSRContext) {
        // This if statement technically breaks the rules of hooks, but is safe because the condition never changes after
        // mounting.
        // eslint-disable-next-line
        _react.useLayoutEffect(()=>{
            setIsSSR(false);
        }, []);
    }
    return isSSR;
}
