'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useSelection", {
    enumerable: true,
    get: function() {
        return useSelection;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _useControllableState = require("../hooks/useControllableState");
const _createSetFromIterable = require("../utils/createSetFromIterable");
function useSelectionState(params) {
    const [selected, setSelected] = (0, _useControllableState.useControllableState)({
        initialState: new Set(),
        defaultState: _react.useMemo(()=>params.defaultSelectedItems && (0, _createSetFromIterable.createSetFromIterable)(params.defaultSelectedItems), [
            params.defaultSelectedItems
        ]),
        state: _react.useMemo(()=>params.selectedItems && (0, _createSetFromIterable.createSetFromIterable)(params.selectedItems), [
            params.selectedItems
        ])
    });
    const changeSelection = (event, nextSelectedItems)=>{
        var _params_onSelectionChange;
        (_params_onSelectionChange = params.onSelectionChange) === null || _params_onSelectionChange === void 0 ? void 0 : _params_onSelectionChange.call(params, event, {
            selectedItems: nextSelectedItems
        });
        setSelected(nextSelectedItems);
    };
    return [
        selected,
        changeSelection
    ];
}
function useSingleSelection(params) {
    const [selected, changeSelection] = useSelectionState(params);
    const methods = {
        deselectItem: (event)=>changeSelection(event, new Set()),
        selectItem: (event, itemId)=>changeSelection(event, new Set([
                itemId
            ])),
        toggleAllItems: ()=>{
            if (process.env.NODE_ENV !== 'production') {
                throw new Error('[react-utilities]: `toggleAllItems` should not be used in single selection mode');
            }
        },
        toggleItem: (event, itemId)=>changeSelection(event, new Set([
                itemId
            ])),
        clearItems: (event)=>changeSelection(event, new Set()),
        isSelected: (itemId)=>{
            var _selected_has;
            return (_selected_has = selected.has(itemId)) !== null && _selected_has !== void 0 ? _selected_has : false;
        }
    };
    return [
        selected,
        methods
    ];
}
function useMultipleSelection(params) {
    const [selected, changeSelection] = useSelectionState(params);
    const methods = {
        toggleItem: (event, itemId)=>{
            const nextSelectedItems = new Set(selected);
            if (selected.has(itemId)) {
                nextSelectedItems.delete(itemId);
            } else {
                nextSelectedItems.add(itemId);
            }
            changeSelection(event, nextSelectedItems);
        },
        selectItem: (event, itemId)=>{
            const nextSelectedItems = new Set(selected);
            nextSelectedItems.add(itemId);
            changeSelection(event, nextSelectedItems);
        },
        deselectItem: (event, itemId)=>{
            const nextSelectedItems = new Set(selected);
            nextSelectedItems.delete(itemId);
            changeSelection(event, nextSelectedItems);
        },
        clearItems: (event)=>{
            changeSelection(event, new Set());
        },
        isSelected: (itemId)=>selected.has(itemId),
        toggleAllItems: (event, itemIds)=>{
            const allItemsSelected = itemIds.every((itemId)=>selected.has(itemId));
            const nextSelectedItems = new Set(selected);
            if (allItemsSelected) {
                nextSelectedItems.clear();
            } else {
                itemIds.forEach((itemId)=>nextSelectedItems.add(itemId));
            }
            changeSelection(event, nextSelectedItems);
        }
    };
    return [
        selected,
        methods
    ];
}
function useSelection(params) {
    'use no memo';
    if (params.selectionMode === 'multiselect') {
        // selectionMode is a static value, so we can safely ignore rules-of-hooks
        // eslint-disable-next-line react-hooks/rules-of-hooks
        return useMultipleSelection(params);
    }
    // selectionMode is a static value, so we can safely ignore rules-of-hooks
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return useSingleSelection(params);
}
