'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTimeout", {
    enumerable: true,
    get: function() {
        return useTimeout;
    }
});
const _useBrowserTimer = require("./useBrowserTimer");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const setTimeoutNoop = (_callback)=>-1;
const clearTimeoutNoop = (_handle)=>undefined;
function useTimeout() {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const win = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView;
    const setTimerFn = win ? win.setTimeout : setTimeoutNoop;
    const clearTimerFn = win ? win.clearTimeout : clearTimeoutNoop;
    return (0, _useBrowserTimer.useBrowserTimer)(setTimerFn, clearTimerFn);
}
