'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useOnScrollOutside", {
    enumerable: true,
    get: function() {
        return useOnScrollOutside;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _useEventCallback = require("./useEventCallback");
const useOnScrollOutside = (options)=>{
    const { refs, callback, element, disabled, contains: containsProp } = options;
    const listener = (0, _useEventCallback.useEventCallback)((ev)=>{
        const contains = containsProp || ((parent, child)=>!!(parent === null || parent === void 0 ? void 0 : parent.contains(child)));
        const target = ev.composedPath()[0];
        const isOutside = refs.every((ref)=>!contains(ref.current || null, target));
        if (isOutside && !disabled) {
            callback(ev);
        }
    });
    _react.useEffect(()=>{
        if (disabled) {
            return;
        }
        element === null || element === void 0 ? void 0 : element.addEventListener('wheel', listener);
        element === null || element === void 0 ? void 0 : element.addEventListener('touchmove', listener);
        return ()=>{
            element === null || element === void 0 ? void 0 : element.removeEventListener('wheel', listener);
            element === null || element === void 0 ? void 0 : element.removeEventListener('touchmove', listener);
        };
    }, [
        listener,
        element,
        disabled
    ]);
};
