'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    IdPrefixProvider: function() {
        return IdPrefixProvider;
    },
    resetIdsForTests: function() {
        return resetIdsForTests;
    },
    useId: function() {
        return useId;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _index = require("../ssr/index");
const IdPrefixContext = _react.createContext(undefined);
const IdPrefixProvider = IdPrefixContext.Provider;
function useIdPrefix() {
    return _react.useContext(IdPrefixContext) || '';
}
function resetIdsForTests() {
    _index.defaultSSRContextValue.current = 0;
}
function useId(prefix = 'fui-', providedId) {
    'use no memo';
    const contextValue = (0, _index.useSSRContext)();
    const idPrefix = useIdPrefix();
    // Checking if useId is available on React, if it is, we use it to generate the id. String concatenation is used to
    // prevent bundlers from complaining with older versions of React.
    const _useId = _react['use' + 'Id'];
    if (_useId) {
        const generatedId = _useId();
        // eslint-disable-next-line react-hooks/rules-of-hooks
        const escapedId = _react.useMemo(()=>generatedId.replace(/:/g, ''), [
            generatedId
        ]);
        return providedId || `${idPrefix}${prefix}${escapedId}`;
    }
    // Hooks appear to be running conditionally, but they will always run in the same order since it's based on
    // the version of React being used. This is safe to ignore.
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return _react.useMemo(()=>{
        if (providedId) {
            return providedId;
        }
        return `${idPrefix}${prefix}${++contextValue.current}`;
    }, [
        idPrefix,
        prefix,
        providedId,
        contextValue
    ]);
}
