'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useEventCallback", {
    enumerable: true,
    get: function() {
        return useEventCallback;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _useIsomorphicLayoutEffect = require("./useIsomorphicLayoutEffect");
const useEventCallback = (fn)=>{
    const callbackRef = _react.useRef(()=>{
        throw new Error('Cannot call an event handler while rendering');
    });
    (0, _useIsomorphicLayoutEffect.useIsomorphicLayoutEffect)(()=>{
        callbackRef.current = fn;
    }, [
        fn
    ]);
    return _react.useCallback((...args)=>{
        const callback = callbackRef.current;
        return callback(...args);
    }, [
        callbackRef
    ]);
};
