'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useBrowserTimer", {
    enumerable: true,
    get: function() {
        return useBrowserTimer;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
function useBrowserTimer(setTimer, cancelTimer) {
    const id = _react.useRef(undefined);
    const set = _react.useCallback((fn, delay)=>{
        if (id.current !== undefined) {
            cancelTimer(id.current);
        }
        id.current = setTimer(fn, delay);
        return id.current;
    }, [
        cancelTimer,
        setTimer
    ]);
    const cancel = _react.useCallback(()=>{
        if (id.current !== undefined) {
            cancelTimer(id.current);
            id.current = undefined;
        }
    }, [
        cancelTimer
    ]);
    // Clean up the timeout when the component is unloaded
    _react.useEffect(()=>cancel, [
        cancel
    ]);
    return [
        set,
        cancel
    ];
}
