'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useAnimationFrame", {
    enumerable: true,
    get: function() {
        return useAnimationFrame;
    }
});
const _useBrowserTimer = require("./useBrowserTimer");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const setAnimationFrameNoop = (callback)=>{
    callback(0);
    return 0;
};
const cancelAnimationFrameNoop = (handle)=>handle;
function useAnimationFrame() {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const win = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView;
    const setAnimationFrame = win ? win.requestAnimationFrame : setAnimationFrameNoop;
    const clearAnimationFrame = win ? win.cancelAnimationFrame : cancelAnimationFrameNoop;
    return (0, _useBrowserTimer.useBrowserTimer)(setAnimationFrame, clearAnimationFrame);
}
