"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getSlots", {
    enumerable: true,
    get: function() {
        return getSlots;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _omit = require("../../utils/omit");
const _isSlot = require("../isSlot");
const _constants = require("../constants");
function getSlots(state) {
    const typeState = state;
    // eslint-disable-next-line @typescript-eslint/no-deprecated
    const slots = {};
    const slotProps = {};
    // eslint-disable-next-line @typescript-eslint/no-deprecated
    const slotNames = Object.keys(typeState.components);
    for (const slotName of slotNames){
        const [slot, props] = getSlot(typeState, slotName);
        // eslint-disable-next-line @typescript-eslint/no-deprecated
        slots[slotName] = slot;
        slotProps[slotName] = props;
    }
    // eslint-disable-next-line @typescript-eslint/no-deprecated
    return {
        slots,
        slotProps: slotProps
    };
}
function getSlot(state, slotName) {
    var _state_components, _state_components1;
    const props = state[slotName];
    if (props === undefined) {
        return [
            null,
            undefined
        ];
    }
    // TS Error: Property 'as' does not exist on type 'UnknownSlotProps | undefined'.ts(2339)
    const { as: asProp, children, ...rest } = props;
    const renderFunction = (0, _isSlot.isSlot)(props) ? props[_constants.SLOT_RENDER_FUNCTION_SYMBOL] : undefined;
    const slot = ((_state_components = state.components) === null || _state_components === void 0 ? void 0 : _state_components[slotName]) === undefined || // eslint-disable-line @typescript-eslint/no-deprecated
    // eslint-disable-next-line @typescript-eslint/no-deprecated
    typeof state.components[slotName] === 'string' ? asProp || ((_state_components1 = state.components) === null || _state_components1 === void 0 ? void 0 : _state_components1[slotName]) || 'div' : state.components[slotName];
    const asserted = slot;
    if (renderFunction || typeof children === 'function') {
        const render = renderFunction || children;
        return [
            _react.Fragment,
            {
                children: render(asserted, rest)
            }
        ];
    }
    const shouldOmitAsProp = typeof slot === 'string' && asProp;
    const slotProps = shouldOmitAsProp ? (0, _omit.omit)(props, [
        'as'
    ]) : props;
    return [
        asserted,
        slotProps
    ];
}
