'use client';
import { useControllableState } from '@fluentui/react-utilities';
import * as React from 'react';
import { ImmutableSet } from '../utils/ImmutableSet';
/**
 * @internal
 */ export function useControllableOpenItems(props) {
    return useControllableState({
        state: React.useMemo(()=>props.openItems && ImmutableSet.from(props.openItems), [
            props.openItems
        ]),
        defaultState: props.defaultOpenItems && (()=>ImmutableSet.from(props.defaultOpenItems)),
        initialState: ImmutableSet.empty
    });
}
/**
 * @internal
 */ export function createNextOpenItems(data, previousOpenItems) {
    return data.open ? previousOpenItems.add(data.value) : previousOpenItems.delete(data.value);
}
