import * as React from 'react';
import { SubtreeContext, TreeContext } from '../contexts';
/**
 * @internal
 */ const rootSubtreeContextValue = {
    level: 1,
    contextType: 'subtree'
};
export const TreeProvider = (props)=>{
    if (props.value.contextType === 'subtree') {
        return /*#__PURE__*/ React.createElement(SubtreeContext.Provider, {
            value: props.value
        }, props.children);
    }
    return /*#__PURE__*/ React.createElement(TreeContext.Provider, {
        value: props.value
    }, /*#__PURE__*/ React.createElement(SubtreeContext.Provider, {
        value: rootSubtreeContextValue
    }, props.children));
};
TreeProvider.displayName = 'TreeProvider';
export const TreeRootReset = (props)=>/*#__PURE__*/ React.createElement(SubtreeContext.Provider, {
        value: undefined
    }, props.children);
