'use client';
import * as React from 'react';
export function useTreeContextValues_unstable(state) {
    'use no memo';
    if (state.contextType === 'root') {
        const { openItems, level, contextType, treeType, checkedItems, selectionMode, navigationMode, appearance, size, requestTreeResponse, forceUpdateRovingTabIndex } = state;
        /**
     * This context is created with "@fluentui/react-context-selector",
     * there is no sense to memoize it
     */ const tree = {
            treeType,
            size,
            openItems,
            appearance,
            checkedItems,
            selectionMode,
            navigationMode,
            contextType,
            level,
            requestTreeResponse,
            forceUpdateRovingTabIndex
        };
        return {
            tree
        };
    }
    return {
        // contextType is statically determined by the context
        // eslint-disable-next-line react-hooks/rules-of-hooks
        tree: React.useMemo(()=>({
                level: state.level,
                contextType: 'subtree'
            }), [
            state.level
        ])
    };
}
